/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authc;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationListener;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.Authenticator;
import org.apache.shiro.authc.LogoutAware;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticator
implements Authenticator,
LogoutAware {
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthenticator.class);
    private Collection<AuthenticationListener> listeners = new ArrayList<AuthenticationListener>();

    public void setAuthenticationListeners(Collection<AuthenticationListener> listeners) {
        this.listeners = listeners == null ? new ArrayList<AuthenticationListener>() : listeners;
    }

    public Collection<AuthenticationListener> getAuthenticationListeners() {
        return this.listeners;
    }

    protected void notifySuccess(AuthenticationToken token, AuthenticationInfo info) {
        for (AuthenticationListener listener : this.listeners) {
            listener.onSuccess(token, info);
        }
    }

    protected void notifyFailure(AuthenticationToken token, AuthenticationException ae) {
        for (AuthenticationListener listener : this.listeners) {
            listener.onFailure(token, ae);
        }
    }

    protected void notifyLogout(PrincipalCollection principals) {
        for (AuthenticationListener listener : this.listeners) {
            listener.onLogout(principals);
        }
    }

    @Override
    public void onLogout(PrincipalCollection principals) {
        this.notifyLogout(principals);
    }

    @Override
    public final AuthenticationInfo authenticate(AuthenticationToken token) throws AuthenticationException {
        AuthenticationInfo info;
        if (token == null) {
            throw new IllegalArgumentException("Method argument (authentication token) cannot be null.");
        }
        log.trace("Authentication attempt received for token [{}]", (Object)token);
        try {
            info = this.doAuthenticate(token);
            if (info == null) {
                String msg = "No account information found for authentication token [" + token + "] by this " + "Authenticator instance.  Please check that it is configured correctly.";
                throw new AuthenticationException(msg);
            }
        }
        catch (Throwable t) {
            AuthenticationException ae;
            block9: {
                ae = null;
                if (t instanceof AuthenticationException) {
                    ae = (AuthenticationException)t;
                }
                if (ae == null) {
                    String msg = "Authentication failed for token submission [" + token + "].  Possible unexpected " + "error? (Typical or expected login exceptions should extend from AuthenticationException).";
                    ae = new AuthenticationException(msg, t);
                    if (log.isWarnEnabled()) {
                        log.warn(msg, t);
                    }
                }
                try {
                    this.notifyFailure(token, ae);
                }
                catch (Throwable t2) {
                    if (!log.isWarnEnabled()) break block9;
                    String msg = "Unable to send notification for failed authentication attempt - listener error?.  Please check your AuthenticationListener implementation(s).  Logging sending exception and propagating original AuthenticationException instead...";
                    log.warn(msg, t2);
                }
            }
            throw ae;
        }
        log.debug("Authentication successful for token [{}].  Returned account [{}]", (Object)token, (Object)info);
        this.notifySuccess(token, info);
        return info;
    }

    protected abstract AuthenticationInfo doAuthenticate(AuthenticationToken var1) throws AuthenticationException;
}

