/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.identityasserter.common.function;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteFunctionProcessor;
import org.apache.knox.gateway.i18n.GatewaySpiMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.identityasserter.common.function.UsernameFunctionDescriptor;
import org.apache.knox.gateway.security.SubjectUtils;

public class UsernameFunctionProcessor
implements UrlRewriteFunctionProcessor<UsernameFunctionDescriptor> {
    private static final GatewaySpiMessages LOG = (GatewaySpiMessages)MessagesFactory.get(GatewaySpiMessages.class);

    public String name() {
        return "username";
    }

    public void initialize(UrlRewriteEnvironment environment, UsernameFunctionDescriptor descriptor) throws Exception {
    }

    public void destroy() throws Exception {
    }

    public List<String> resolve(UrlRewriteContext context, List<String> parameters) throws Exception {
        ArrayList<String> results = null;
        Subject subject = SubjectUtils.getCurrentSubject();
        if (subject != null) {
            results = new ArrayList<String>(1);
            String username = SubjectUtils.getEffectivePrincipalName((Subject)subject);
            results.add(username);
        } else if (parameters != null && !parameters.isEmpty()) {
            results = new ArrayList(1);
            results.add(parameters.get(0));
        }
        return results;
    }
}

