/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.http.ajax;

import org.pac4j.core.context.HttpConstants;
import org.pac4j.core.context.Pac4jConstants;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.http.ajax.AjaxRequestResolver;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.util.CommonHelper;

public class DefaultAjaxRequestResolver
implements AjaxRequestResolver,
HttpConstants,
Pac4jConstants {
    @Override
    public boolean isAjax(WebContext context) {
        boolean xmlHttpRequest = "XMLHttpRequest".equalsIgnoreCase(context.getRequestHeader("X-Requested-With"));
        boolean hasDynamicAjaxParameter = Boolean.TRUE.toString().equalsIgnoreCase(context.getRequestHeader("is_ajax_request"));
        boolean hasDynamicAjaxHeader = Boolean.TRUE.toString().equalsIgnoreCase(context.getRequestParameter("is_ajax_request"));
        return xmlHttpRequest || hasDynamicAjaxParameter || hasDynamicAjaxHeader;
    }

    @Override
    public RedirectAction buildAjaxResponse(String url, WebContext context) {
        if (CommonHelper.isBlank(context.getRequestParameter("javax.faces.partial.ajax"))) {
            if (CommonHelper.isNotBlank(url)) {
                context.setResponseHeader("Location", url);
            }
            throw HttpAction.unauthorized(context);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<?xml version='1.0' encoding='UTF-8'?>");
        buffer.append("<partial-response>");
        buffer.append("<redirect url=\"" + url.replaceAll("&", "&amp;") + "\"></redirect>");
        buffer.append("</partial-response>");
        return RedirectAction.success(buffer.toString());
    }
}

