/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.constants;

import org.apache.directory.api.i18n.I18n;

public enum AuthenticationLevel {
    NONE(0, "none"),
    SIMPLE(1, "simple"),
    STRONG(2, "strong"),
    UNAUTHENT(3, "unauthent");

    private int level;
    private final String name;

    private AuthenticationLevel(int level, String name) {
        this.level = level;
        this.name = name;
    }

    public int getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static AuthenticationLevel getLevel(int val) {
        switch (val) {
            case 0: {
                return NONE;
            }
            case 1: {
                return SIMPLE;
            }
            case 2: {
                return STRONG;
            }
            case 3: {
                return UNAUTHENT;
            }
        }
        throw new IllegalArgumentException(I18n.err(I18n.ERR_05001_UNKNOWN_AUTHENT_LEVEL, val));
    }
}

