/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.LdapResultDecorator;
import org.apache.directory.api.ldap.codec.decorators.ResponseDecorator;
import org.apache.directory.api.ldap.model.message.BindResponse;

public class BindResponseDecorator
extends ResponseDecorator<BindResponse>
implements BindResponse {
    private int bindResponseLength;

    public BindResponseDecorator(LdapApiService codec, BindResponse decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public byte[] getServerSaslCreds() {
        return ((BindResponse)this.getDecorated()).getServerSaslCreds();
    }

    public void setServerSaslCreds(byte[] serverSaslCreds) {
        ((BindResponse)this.getDecorated()).setServerSaslCreds(serverSaslCreds);
    }

    public int computeLength() {
        int ldapResultLength;
        BindResponse bindResponse = (BindResponse)this.getDecorated();
        this.bindResponseLength = ldapResultLength = ((LdapResultDecorator)this.getLdapResult()).computeLength();
        byte[] serverSaslCreds = bindResponse.getServerSaslCreds();
        if (serverSaslCreds != null) {
            this.bindResponseLength += 1 + TLV.getNbBytes((int)serverSaslCreds.length) + serverSaslCreds.length;
        }
        return 1 + TLV.getNbBytes((int)this.bindResponseLength) + this.bindResponseLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        BindResponse bindResponse = (BindResponse)this.getDecorated();
        try {
            buffer.put((byte)97);
            buffer.put(TLV.getBytes((int)this.bindResponseLength));
            ((LdapResultDecorator)this.getLdapResult()).encode(buffer);
            byte[] serverSaslCreds = bindResponse.getServerSaslCreds();
            if (serverSaslCreds != null) {
                buffer.put((byte)-121);
                buffer.put(TLV.getBytes((int)serverSaslCreds.length));
                if (serverSaslCreds.length != 0) {
                    buffer.put(serverSaslCreds);
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_08212_PDU_BUFFER_TOO_SMALL, (Object[])new Object[0]), (Exception)boe);
        }
        return buffer;
    }
}

