/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery;

import java.lang.reflect.Field;
import java.util.ServiceLoader;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.topology.discovery.GatewayService;
import org.apache.knox.gateway.topology.discovery.ServiceDiscovery;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryType;

public abstract class ServiceDiscoveryFactory {
    private static final Service[] NO_GATEWAY_SERVICS = new Service[0];

    public static ServiceDiscovery get(String type) {
        return ServiceDiscoveryFactory.get(type, NO_GATEWAY_SERVICS);
    }

    public static ServiceDiscovery get(String type, Service ... gatewayServices) {
        ServiceDiscovery sd = null;
        ServiceLoader<ServiceDiscoveryType> loader = ServiceLoader.load(ServiceDiscoveryType.class);
        for (ServiceDiscoveryType sdt : loader) {
            if (!sdt.getType().equalsIgnoreCase(type)) continue;
            try {
                ServiceDiscovery instance = sdt.newInstance();
                if (!instance.getType().equalsIgnoreCase(type)) continue;
                sd = instance;
                if (gatewayServices == null || gatewayServices.length <= 0) break;
                for (Field field : sd.getClass().getDeclaredFields()) {
                    if (field.getDeclaredAnnotation(GatewayService.class) == null) continue;
                    for (Service s : gatewayServices) {
                        if (s == null || !field.getType().isAssignableFrom(s.getClass())) continue;
                        field.setAccessible(true);
                        field.set(sd, s);
                    }
                }
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sd;
    }
}

