/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.cache;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.cache.Cache;

public class LRUCache<Q extends SearchRequest>
implements Cache<Q> {
    private static final int INITIAL_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private Map<Q, Item> cache;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    });

    public LRUCache(final int size, final long timeToLive, long interval) {
        this.cache = new LinkedHashMap<Q, Item>(16, 0.75f, true){
            private static final long serialVersionUID = -4082551016104288539L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Q, Item> entry) {
                return this.size() > size;
            }
        };
        Runnable expire = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = LRUCache.this.cache;
                synchronized (map) {
                    Iterator i = LRUCache.this.cache.values().iterator();
                    long t = System.currentTimeMillis();
                    while (i.hasNext()) {
                        Item item = (Item)i.next();
                        if (t - item.creationTime <= TimeUnit.SECONDS.toMillis(timeToLive)) continue;
                        i.remove();
                    }
                }
            }
        };
        this.executor.scheduleAtFixedRate(expire, interval, interval, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<Q, Item> map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchResult get(Q request) {
        Map<Q, Item> map = this.cache;
        synchronized (map) {
            if (this.cache.containsKey(request)) {
                return this.cache.get(request).result;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Q request, SearchResult result) {
        Map<Q, Item> map = this.cache;
        synchronized (map) {
            this.cache.put(request, new Item(result));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Map<Q, Item> map = this.cache;
        synchronized (map) {
            return this.cache.size();
        }
    }

    public void close() {
        this.executor.shutdown();
        this.cache = null;
    }

    private class Item {
        private final SearchResult result;
        private final long creationTime;

        public Item(SearchResult sr) {
            this.result = sr;
            this.creationTime = System.currentTimeMillis();
        }
    }
}

