/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.creator;

import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.oauth.OAuth10aService;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.pac4j.oauth.credentials.OAuth10Credentials;
import org.pac4j.oauth.profile.OAuth10Profile;
import org.pac4j.oauth.profile.OAuth20Profile;
import org.pac4j.oauth.profile.creator.OAuthProfileCreator;

public class OAuth10ProfileCreator<U extends OAuth10Profile>
extends OAuthProfileCreator<OAuth10Credentials, U, OAuth10Configuration, OAuth1AccessToken, OAuth10aService> {
    public OAuth10ProfileCreator(OAuth10Configuration configuration, IndirectClient client) {
        super(configuration, client);
    }

    @Override
    protected OAuth1AccessToken getAccessToken(OAuth10Credentials credentials) {
        return credentials.getAccessToken();
    }

    @Override
    protected void addAccessTokenToProfile(U profile, OAuth1AccessToken accessToken) {
        if (profile != null) {
            String token = accessToken.getToken();
            this.logger.debug("add access_token: {} to profile", (Object)token);
            ((OAuth20Profile)((Object)profile)).setAccessToken(token);
            ((OAuth10Profile)((Object)profile)).setAccessSecret(accessToken.getTokenSecret());
        }
    }

    @Override
    protected void signRequest(OAuth10aService service, OAuth1AccessToken token, OAuthRequest request) {
        service.signRequest(token, request);
        if (((OAuth10Configuration)this.configuration).isTokenAsHeader()) {
            request.addHeader("Authorization", "Bearer " + token.getToken());
        }
    }
}

