/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.provider.federation.jwt.filter;

import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.filter.security.AbstractIdentityAssertionFilter;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.registry.ServiceRegistry;
import org.apache.knox.gateway.services.security.token.JWTokenAttributesBuilder;
import org.apache.knox.gateway.services.security.token.JWTokenAuthority;
import org.apache.knox.gateway.services.security.token.TokenServiceException;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.util.JsonUtils;

public class JWTAuthCodeAssertionFilter
extends AbstractIdentityAssertionFilter {
    private JWTokenAuthority authority;
    private ServiceRegistry sr;
    private String tokenIssuer;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String validityStr = filterConfig.getInitParameter("validity");
        if (validityStr == null) {
            validityStr = "3600";
        }
        GatewayServices services = (GatewayServices)filterConfig.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        this.authority = (JWTokenAuthority)services.getService(ServiceType.TOKEN_SERVICE);
        this.sr = (ServiceRegistry)services.getService(ServiceType.SERVICE_REGISTRY_SERVICE);
        this.tokenIssuer = StringUtils.isBlank((CharSequence)filterConfig.getInitParameter("knox.token.issuer")) ? "KNOXSSO" : filterConfig.getInitParameter("knox.token.issuer");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException {
        Subject subject = Subject.getSubject(AccessController.getContext());
        String principalName = this.getPrincipalName(subject);
        principalName = this.mapper.mapUserPrincipal(principalName);
        try {
            JWT authCode = this.authority.issueToken(new JWTokenAttributesBuilder().setIssuer(this.tokenIssuer).setUserName(principalName).setAlgorithm(this.signatureAlgorithm).build());
            String url = null;
            if (this.sr != null) {
                url = this.sr.lookupServiceURL("token", "TGS");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            if (authCode != null) {
                map.put("iss", authCode.getIssuer());
                map.put("sub", authCode.getPrincipal());
                map.put("aud", authCode.getAudience());
                map.put("exp", authCode.getExpires());
                map.put("code", authCode.toString());
            }
            if (url != null) {
                map.put("tke", url);
            }
            String jsonResponse = JsonUtils.renderAsJsonString(map);
            response.getWriter().write(jsonResponse);
        }
        catch (TokenServiceException e) {
            e.printStackTrace();
        }
    }
}

