/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.jobhistory.util;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.common.utils.Utils;
import org.apache.linkis.governance.common.protocol.conf.DepartmentRequest;
import org.apache.linkis.governance.common.protocol.conf.DepartmentResponse;
import org.apache.linkis.jobhistory.conversions.TaskConversions;
import org.apache.linkis.jobhistory.entity.QueryTaskVO;
import org.apache.linkis.rpc.Sender;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class JobhistoryUtils {
    public static String headersStr = "\u4efb\u52a1ID,\u6765\u6e90,\u67e5\u8be2\u8bed\u53e5,\u72b6\u6001,\u5df2\u8017\u65f6,\u5173\u952e\u4fe1\u606f,\u662f\u5426\u590d\u7528,\u7533\u8bf7\u5f00\u59cb\u65f6\u95f4,\u7533\u8bf7\u7ed3\u675f\u65f6\u95f4,\u7533\u8bf7\u8017\u65f6,\u5e94\u7528/\u5f15\u64ce,\u7528\u6237,\u521b\u5efa\u65f6\u95f4";
    public static String headersEnStr = "JobID,Source,Execution Code,Status,Time Elapsed,Key Information,IsRuse,Application Start Time,Application End Time,Application Takes Time,App / Engine,User,Created at";
    private static Sender sender = Sender.getSender((String)((String)Configuration.CLOUD_CONSOLE_CONFIGURATION_SPRING_APPLICATION_NAME().getValue()));

    public static byte[] downLoadJobToExcel(List<QueryTaskVO> jobHistoryList, String language, Boolean isAdminView, Boolean isDeptView, Long pageInfo) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XSSFWorkbook workbook = new XSSFWorkbook();
        byte[] byteArray = new byte[]{};
        Sheet sheet = workbook.createSheet("\u4efb\u52a1\u4fe1\u606f\u8868");
        Row headerRow = sheet.createRow(0);
        String headers = "";
        Boolean viewResult = isAdminView != false || isDeptView != false;
        headers = !"en".equals(language) ? (viewResult.booleanValue() ? headersStr : headersStr.replace(",\u7528\u6237", "")) : (viewResult != false ? headersEnStr : headersEnStr.replace(",User", ""));
        String[] headersArray = headers.split(",");
        for (int i = 0; i < headersArray.length; ++i) {
            Cell cell = headerRow.createCell(i);
            cell.setCellValue(headersArray[i]);
        }
        int rowNum = 1;
        List batches = Lists.partition(jobHistoryList, (int)5000);
        for (List queryTaskList : batches) {
            for (QueryTaskVO queryTaskVO : queryTaskList) {
                Row row = sheet.createRow(rowNum++);
                JobhistoryUtils.createCell(row, 0, queryTaskVO.getTaskID());
                JobhistoryUtils.createCell(row, 1, queryTaskVO.getSourceTailor());
                JobhistoryUtils.createCell(row, 2, JobhistoryUtils.abbreviateExecutionCode(queryTaskVO.getExecutionCode()));
                JobhistoryUtils.createCell(row, 3, queryTaskVO.getStatus());
                if (null == queryTaskVO.getCostTime()) {
                    queryTaskVO.setCostTime(0L);
                }
                JobhistoryUtils.createCell(row, 4, Utils.msDurationToString((long)queryTaskVO.getCostTime()));
                JobhistoryUtils.createCell(row, 5, queryTaskVO.getErrDesc());
                JobhistoryUtils.createCell(row, 6, JobhistoryUtils.formatIsReuse(queryTaskVO.getIsReuse()));
                JobhistoryUtils.createCell(row, 7, JobhistoryUtils.formatDateTime(queryTaskVO.getRequestStartTime()));
                JobhistoryUtils.createCell(row, 8, JobhistoryUtils.formatDateTime(queryTaskVO.getRequestEndTime()));
                if (null == queryTaskVO.getRequestSpendTime()) {
                    queryTaskVO.setRequestSpendTime(0L);
                }
                JobhistoryUtils.createCell(row, 9, Utils.msDurationToString((long)queryTaskVO.getRequestSpendTime()));
                JobhistoryUtils.createCell(row, 10, JobhistoryUtils.formatExecuteApplicationName(queryTaskVO.getExecuteApplicationName(), queryTaskVO.getRequestApplicationName()));
                if (viewResult.booleanValue()) {
                    JobhistoryUtils.createCell(row, 11, queryTaskVO.getUmUser());
                    JobhistoryUtils.createCell(row, 12, JobhistoryUtils.formatDateTime(queryTaskVO.getCreatedTime()));
                    continue;
                }
                JobhistoryUtils.createCell(row, 11, JobhistoryUtils.formatDateTime(queryTaskVO.getCreatedTime()));
            }
        }
        try {
            workbook.write((OutputStream)outputStream);
            byteArray = outputStream.toByteArray();
            workbook.close();
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        return byteArray;
    }

    public static String getDepartmentByuser(String username) {
        DepartmentResponse departmentResponse;
        String departmentId = "";
        Object responseObject = sender.ask((Object)new DepartmentRequest(username));
        if (responseObject instanceof DepartmentResponse && StringUtils.isNotBlank((CharSequence)(departmentResponse = (DepartmentResponse)responseObject).departmentId())) {
            departmentId = departmentResponse.departmentId();
        }
        return departmentId;
    }

    private static void createCell(Row row, int columnIndex, Object value) {
        Cell cell = row.createCell(columnIndex);
        if (value != null) {
            cell.setCellValue(value.toString());
        }
    }

    private static String abbreviateExecutionCode(String executionCode) {
        return StringUtils.abbreviate((String)executionCode, (int)1000);
    }

    private static String formatIsReuse(Boolean isReuse) {
        return isReuse != null ? (isReuse.booleanValue() ? "\u662f" : "\u5426") : "";
    }

    private static String formatDateTime(Date date) {
        return date != null ? TaskConversions.dateFomat(date) : "";
    }

    private static String formatExecuteApplicationName(String executeApplicationName, String requestApplicationName) {
        return requestApplicationName + "/" + executeApplicationName;
    }
}

