/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.utils;

public class ScanUtils {
    public static int getNumOfLines(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        int lines = 1;
        int len = str.length();
        for (int pos = 0; pos < len; ++pos) {
            char c = str.charAt(pos);
            if (c == '\r') {
                ++lines;
                if (pos + 1 >= len || str.charAt(pos + 1) != '\n') continue;
                ++pos;
                continue;
            }
            if (c != '\n') continue;
            ++lines;
        }
        return lines;
    }

    public static int getFirstIndexSkippingLines(String str, Integer lines) {
        if (str == null || str.length() == 0 || lines < 0) {
            return -1;
        }
        if (lines == 0) {
            return 0;
        }
        int curLineIdx = 0;
        int len = str.length();
        for (int pos = 0; pos < len; ++pos) {
            char c = str.charAt(pos);
            if (c == '\r') {
                ++curLineIdx;
                if (pos + 1 < len && str.charAt(pos + 1) == '\n') {
                    ++pos;
                }
            } else {
                if (c != '\n') continue;
                ++curLineIdx;
            }
            if (curLineIdx < lines) continue;
            return pos + 1;
        }
        return -1;
    }
}

