/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.plugin;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.DynamicParameter;
import com.github.xiaoymin.knife4j.annotations.DynamicResponseParameters;
import com.github.xiaoymin.knife4j.core.util.StrUtil;
import com.github.xiaoymin.knife4j.spring.util.ByteUtils;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.schema.ViewProviderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.readers.operation.ResponseMessagesReader;

@Component
@Order(value=-2147482598)
public class DynamicResponseModelReader
implements OperationBuilderPlugin {
    private final TypeNameExtractor typeNameExtractor;
    private final EnumTypeDeterminer typeDeterminer;
    private final SchemaPluginsManager pluginsManager;
    private final Map<String, String> cacheGenModelMaps = new HashMap<String, String>();
    @Autowired
    private TypeResolver typeResolver;

    @Autowired
    public DynamicResponseModelReader(TypeNameExtractor typeNameExtractor, EnumTypeDeterminer typeDeterminer, SchemaPluginsManager pluginsManager) {
        this.typeNameExtractor = typeNameExtractor;
        this.typeDeterminer = typeDeterminer;
        this.pluginsManager = pluginsManager;
    }

    public void apply(OperationContext context) {
        Optional parametersOptional;
        long count;
        DynamicResponseParameters dynamicResponseParameters;
        Optional optional = context.findAnnotation(ApiOperationSupport.class);
        boolean flag = false;
        if (optional.isPresent() && (dynamicResponseParameters = ((ApiOperationSupport)optional.get()).responses()) != null && dynamicResponseParameters.properties() != null && dynamicResponseParameters.properties().length > 0 && (count = Arrays.asList(dynamicResponseParameters.properties()).stream().filter(dynamicParameter -> StrUtil.isNotBlank((CharSequence)dynamicParameter.name())).count()) > 0L) {
            flag = true;
            this.changeResponseModel(((ApiOperationSupport)optional.get()).responses(), context);
        }
        if (!flag && (parametersOptional = context.findAnnotation(DynamicResponseParameters.class)).isPresent()) {
            this.changeResponseModel((DynamicResponseParameters)parametersOptional.get(), context);
        }
    }

    private void changeResponseModel(DynamicResponseParameters dynamicResponseParameters, OperationContext operationContext) {
        if (dynamicResponseParameters != null) {
            DynamicParameter[] parameters = dynamicResponseParameters.properties();
            int fieldCount = 0;
            for (DynamicParameter dynamicParameter : parameters) {
                if (dynamicParameter.name() == null || "".equals(dynamicParameter.name()) || "null".equals(dynamicParameter.name())) continue;
                ++fieldCount;
            }
            if (fieldCount > 0) {
                String name = dynamicResponseParameters.name();
                if (name == null || "".equals(name)) {
                    name = this.genClassName(operationContext);
                }
                if (this.cacheGenModelMaps.containsKey(name)) {
                    name = this.genClassName(operationContext);
                }
                name = operationContext.getGroupName().replaceAll("[_-]", "") + "." + name + "Response";
                String classPath = "com.github.xiaoymin.knife4j.model." + name;
                Class<?> loadClass = ByteUtils.load(classPath);
                if (loadClass != null) {
                    ResolvedType returnType = operationContext.alternateFor(this.typeResolver.resolve(loadClass, new Type[0]));
                    int httpStatusCode = ResponseMessagesReader.httpStatusCode((OperationContext)operationContext);
                    String message = ResponseMessagesReader.message((OperationContext)operationContext);
                    ModelReference modelRef = null;
                    if (!ResolvedTypes.isVoid((ResolvedType)returnType)) {
                        ViewProviderPlugin viewProvider = this.pluginsManager.viewProvider(operationContext.getDocumentationContext().getDocumentationType());
                        ModelContext modelContext = ModelContext.returnValue((String)"", (String)operationContext.getGroupName(), (ResolvedType)returnType, (Optional)viewProvider.viewFor(operationContext), (DocumentationType)operationContext.getDocumentationType(), (AlternateTypeProvider)operationContext.getAlternateTypeProvider(), (GenericTypeNamingStrategy)operationContext.getGenericsNamingStrategy(), (Set)operationContext.getIgnorableParameterTypes());
                        modelRef = (ModelReference)ResolvedTypes.modelRefFactory((ModelContext)modelContext, (EnumTypeDeterminer)this.typeDeterminer, (TypeNameExtractor)this.typeNameExtractor).apply(returnType);
                    }
                    ResponseMessage built = new ResponseMessageBuilder().code(httpStatusCode).message(message).responseModel(modelRef).build();
                    HashSet<ResponseMessage> sets = new HashSet<ResponseMessage>();
                    sets.add(built);
                    operationContext.operationBuilder().responseMessages(sets);
                }
            }
        }
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public String genClassName(OperationContext context) {
        String name = context.getName();
        if (name != null && !"".equals(name)) {
            name = (name = name.replaceAll("[_-]", "")).length() == 1 ? name.toUpperCase() : name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return name;
    }
}

