/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.ujes.route.contextservice;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.cs.common.entity.source.ContextIDParser;
import org.apache.linkis.cs.common.entity.source.HAContextID;
import org.apache.linkis.cs.common.utils.CSHighAvailableUtils;
import org.apache.linkis.instance.label.service.InsLabelServiceAdapter;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.protocol.label.LabelInsQueryRequest;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0001u4Aa\u0002\u0005\u0001/!)1\u0007\u0001C\u0001i!Iq\u0007\u0001a\u0001\u0002\u0004%I\u0001\u000f\u0005\n\u0007\u0002\u0001\r\u00111A\u0005\n\u0011C\u0011\"\u0014\u0001A\u0002\u0003\u0005\u000b\u0015B\u001d\t\u000b]\u0003A\u0011\t-\t\u000b1\u0004A\u0011B7\u0003'\r{g\u000e^3yi&#\u0007+\u0019:tKJLU\u000e\u001d7\u000b\u0005%Q\u0011AD2p]R,\u0007\u0010^:feZL7-\u001a\u0006\u0003\u00171\tQA]8vi\u0016T!!\u0004\b\u0002\tUTWm\u001d\u0006\u0003\u001fA\tqaZ1uK^\f\u0017P\u0003\u0002\u0012%\u00051A.\u001b8lSNT!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u0019A1\u0002\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\t1\fgn\u001a\u0006\u0002;\u0005!!.\u0019<b\u0013\ty\"D\u0001\u0004PE*,7\r\u001e\t\u0003C)j\u0011A\t\u0006\u0003G\u0011\naa]8ve\u000e,'BA\u0013'\u0003\u0019)g\u000e^5us*\u0011q\u0005K\u0001\u0007G>lWn\u001c8\u000b\u0005%\u0002\u0012AA2t\u0013\tY#EA\bD_:$X\r\u001f;J\tB\u000b'o]3s!\ti\u0013'D\u0001/\u0015\ty\u0003'A\u0003vi&d7O\u0003\u0002(!%\u0011!G\f\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tQ\u0007\u0005\u00027\u00015\t\u0001\"A\bj]Nd\u0015MY3m'\u0016\u0014h/[2f+\u0005I\u0004C\u0001\u001eB\u001b\u0005Y$B\u0001\u001f>\u0003\u001d\u0019XM\u001d<jG\u0016T!AP \u0002\u000b1\f'-\u001a7\u000b\u0005\u0001\u0003\u0012\u0001C5ogR\fgnY3\n\u0005\t[$AF%og2\u000b'-\u001a7TKJ4\u0018nY3BI\u0006\u0004H/\u001a:\u0002'%t7\u000fT1cK2\u001cVM\u001d<jG\u0016|F%Z9\u0015\u0005\u0015[\u0005C\u0001$J\u001b\u00059%\"\u0001%\u0002\u000bM\u001c\u0017\r\\1\n\u0005);%\u0001B+oSRDq\u0001T\u0002\u0002\u0002\u0003\u0007\u0011(A\u0002yIE\n\u0001#\u001b8t\u0019\u0006\u0014W\r\\*feZL7-\u001a\u0011)\u0005\u0011y\u0005C\u0001)V\u001b\u0005\t&B\u0001*T\u0003)\tgN\\8uCRLwN\u001c\u0006\u0002)\u0006)!.\u0019<bq&\u0011a+\u0015\u0002\t%\u0016\u001cx.\u001e:dK\u0006)\u0001/\u0019:tKR\u0011\u0011L\u001b\t\u00045v{V\"A.\u000b\u0005qc\u0012\u0001B;uS2L!AX.\u0003\t1K7\u000f\u001e\t\u0003A\u001et!!Y3\u0011\u0005\t<U\"A2\u000b\u0005\u00114\u0012A\u0002\u001fs_>$h(\u0003\u0002g\u000f\u00061\u0001K]3eK\u001aL!\u0001[5\u0003\rM#(/\u001b8h\u0015\t1w\tC\u0003l\u000b\u0001\u0007q,A\u0005d_:$X\r\u001f;JI\u0006\u0011r-\u001a;J]N$\u0018M\\2f\u0005f\fE.[1t)\tq'\u000f\u0005\u0002pa6\t\u0001'\u0003\u0002ra\ty1+\u001a:wS\u000e,\u0017J\\:uC:\u001cW\rC\u0003t\r\u0001\u0007q,A\u0003bY&\f7\u000f\u000b\u0002\u0001kB\u0011ao_\u0007\u0002o*\u0011\u00010_\u0001\u000bgR,'/Z8usB,'B\u0001>\u0015\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\\u0017B\u0001?x\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class ContextIdParserImpl
implements ContextIDParser,
Logging {
    @Resource
    private InsLabelServiceAdapter insLabelService;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        ContextIdParserImpl contextIdParserImpl = this;
        synchronized (contextIdParserImpl) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private InsLabelServiceAdapter insLabelService() {
        return this.insLabelService;
    }

    private void insLabelService_$eq(InsLabelServiceAdapter x$1) {
        this.insLabelService = x$1;
    }

    public List<String> parse(String contextId) {
        if (CSHighAvailableUtils.checkHAIDBasicFormat((String)contextId)) {
            Boolean bl;
            Boolean bl2;
            ArrayList<String> instances = new ArrayList<String>(2);
            HAContextID haContextID = CSHighAvailableUtils.decodeHAID((String)contextId);
            ServiceInstance mainInstance = this.getInstanceByAlias(haContextID.getInstance());
            if (mainInstance != null) {
                bl2 = BoxesRunTime.boxToBoolean((boolean)instances.add(mainInstance.getInstance()));
            } else {
                this.logger().error(new StringBuilder(39).append("parse HAID instance invalid. haIDKey : ").append(contextId).toString());
                bl2 = BoxedUnit.UNIT;
            }
            ServiceInstance backupInstance = this.getInstanceByAlias(haContextID.getBackupInstance());
            if (backupInstance != null) {
                bl = BoxesRunTime.boxToBoolean((boolean)instances.add(backupInstance.getInstance()));
            } else {
                this.logger().error(new StringBuilder(45).append("parse HAID backupInstance invalid. haIDKey : ").append(contextId).toString());
                bl = BoxedUnit.UNIT;
            }
            return instances;
        }
        return new ArrayList<String>(0);
    }

    private ServiceInstance getInstanceByAlias(String alias) {
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            return (ServiceInstance)Utils$.MODULE$.tryAndError((Function0 & Serializable & scala.Serializable)() -> {
                ServiceInstance serviceInstance;
                block0: {
                    LabelInsQueryRequest request = new LabelInsQueryRequest();
                    HashMap<String, String> labelMap = new HashMap<String, String>();
                    labelMap.put("route", alias);
                    request.setLabels(labelMap);
                    serviceInstance = null;
                    ArrayList<Label> labels = new ArrayList<Label>();
                    labels.add(LabelBuilderFactoryContext.getLabelBuilderFactory().createLabel("route", (Object)alias));
                    List insList = this.insLabelService().searchInstancesByLabels(labels);
                    if (insList == null || insList.isEmpty()) break block0;
                    serviceInstance = (ServiceInstance)insList.get(0);
                }
                return serviceInstance;
            }, this.logger());
        }
        return null;
    }

    public ContextIdParserImpl() {
        Logging.$init$((Logging)this);
    }
}

