/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc.sink;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.ClassUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcPlugin;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcSink;
import org.apache.linkis.engineplugin.spark.datacalc.model.SinkConfig;
import org.apache.linkis.engineplugin.spark.datacalc.sink.JdbcSinkConfig;
import org.apache.spark.package$;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001%4A\u0001B\u0003\u0001)!)Q\u0006\u0001C\u0001]!)\u0001\u0007\u0001C\u0001c!)Q\t\u0001C\u0005\r\nA!\n\u001a2d'&t7N\u0003\u0002\u0007\u000f\u0005!1/\u001b8l\u0015\tA\u0011\"\u0001\u0005eCR\f7-\u00197d\u0015\tQ1\"A\u0003ta\u0006\u00148N\u0003\u0002\r\u001b\u0005aQM\\4j]\u0016\u0004H.^4j]*\u0011abD\u0001\u0007Y&t7.[:\u000b\u0005A\t\u0012AB1qC\u000eDWMC\u0001\u0013\u0003\ry'oZ\u0002\u0001'\u0011\u0001QcG\u0013\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\rar$I\u0007\u0002;)\u0011adB\u0001\u0004CBL\u0017B\u0001\u0011\u001e\u00051!\u0015\r^1DC2\u001c7+\u001b8l!\t\u00113%D\u0001\u0006\u0013\t!SA\u0001\bKI\n\u001c7+\u001b8l\u0007>tg-[4\u0011\u0005\u0019ZS\"A\u0014\u000b\u0005!J\u0013!B;uS2\u001c(B\u0001\u0016\u000e\u0003\u0019\u0019w.\\7p]&\u0011Af\n\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tq\u0006\u0005\u0002#\u0001\u00051q.\u001e;qkR$2AM\u001b>!\t12'\u0003\u00025/\t!QK\\5u\u0011\u0015Q!\u00011\u00017!\t94(D\u00019\u0015\tI$(A\u0002tc2T!AC\b\n\u0005qB$\u0001D*qCJ\\7+Z:tS>t\u0007\"\u0002 \u0003\u0001\u0004y\u0014A\u00013t!\r9\u0004IQ\u0005\u0003\u0003b\u0012q\u0001R1uCN,G\u000f\u0005\u00028\u0007&\u0011A\t\u000f\u0002\u0004%><\u0018aB3yK\u000e,H/\u001a\u000b\u0005e\u001d\u0003F\fC\u0003I\u0007\u0001\u0007\u0011*\u0001\u0003d_:t\u0007C\u0001&O\u001b\u0005Y%BA\u001dM\u0015\u0005i\u0015\u0001\u00026bm\u0006L!aT&\u0003\u0015\r{gN\\3di&|g\u000eC\u0003R\u0007\u0001\u0007!+A\u0006kI\n\u001cw\n\u001d;j_:\u001c\bCA*[\u001b\u0005!&BA+W\u0003\u0011QGMY2\u000b\u0005]C\u0016a\u00033bi\u0006\u001cx.\u001e:dKNT!!\u0017\u001d\u0002\u0013\u0015DXmY;uS>t\u0017BA.U\u0005-QEIQ\"PaRLwN\\:\t\u000bu\u001b\u0001\u0019\u00010\u0002\u000bE,XM]=\u0011\u0005}3gB\u00011e!\t\tw#D\u0001c\u0015\t\u00197#\u0001\u0004=e>|GOP\u0005\u0003K^\ta\u0001\u0015:fI\u00164\u0017BA4i\u0005\u0019\u0019FO]5oO*\u0011Qm\u0006")
public class JdbcSink
implements DataCalcSink<JdbcSinkConfig>,
Logging {
    private Logger logger;
    private JdbcSinkConfig config;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    @Override
    public Object getConfig() {
        return DataCalcPlugin.getConfig$(this);
    }

    @Override
    public void setConfig(Object config) {
        DataCalcPlugin.setConfig$(this, config);
    }

    @Override
    public void prepare(SparkSession spark) {
        DataCalcPlugin.prepare$(this, spark);
    }

    private Logger logger$lzycompute() {
        JdbcSink jdbcSink = this;
        synchronized (jdbcSink) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public JdbcSinkConfig config() {
        return this.config;
    }

    @Override
    public void config_$eq(JdbcSinkConfig x$1) {
        this.config = x$1;
    }

    @Override
    public void output(SparkSession spark, Dataset<Row> ds) {
        String targetTable = StringUtils.isBlank((CharSequence)((JdbcSinkConfig)this.config()).getTargetDatabase()) ? ((JdbcSinkConfig)this.config()).getTargetTable() : new StringBuilder(1).append(((JdbcSinkConfig)this.config()).getTargetDatabase()).append(".").append(((JdbcSinkConfig)this.config()).getTargetTable()).toString();
        ObjectRef options = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)((JdbcSinkConfig)this.config()).getUrl()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"driver"), (Object)((JdbcSinkConfig)this.config()).getDriver()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)((JdbcSinkConfig)this.config()).getUser()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"password"), (Object)((JdbcSinkConfig)this.config()).getPassword()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)targetTable), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connectionCollation"), (Object)"utf8mb4_unicode_ci")}))));
        if (((SinkConfig)this.config()).getOptions() != null && !((SinkConfig)this.config()).getOptions().isEmpty()) {
            options.elem = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(((SinkConfig)this.config()).getOptions()).asScala()).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((scala.collection.immutable.Map)options.elem));
        }
        options.elem = ((scala.collection.immutable.Map)options.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isolationLevel"), ((scala.collection.immutable.Map)options.elem).getOrElse((Object)"isolationLevel", (Function0 & Serializable & scala.Serializable)() -> "NONE")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"batchsize"), ((scala.collection.immutable.Map)options.elem).getOrElse((Object)"batchsize", (Function0 & Serializable & scala.Serializable)() -> "5000"))})));
        if (((JdbcSinkConfig)this.config()).getPreQueries() != null && !((JdbcSinkConfig)this.config()).getPreQueries().isEmpty()) {
            spark.sql("select 1").repartition(1).foreachPartition((Function1 & Serializable & scala.Serializable)x$1 -> {
                JdbcSink.$anonfun$output$3(this, options, x$1);
                return BoxedUnit.UNIT;
            });
        }
        DataFrameWriter writer = ds.repartition(Predef$.MODULE$.Integer2int(((JdbcSinkConfig)this.config()).getNumPartitions())).write().format("jdbc");
        Object object = StringUtils.isNotBlank((CharSequence)((JdbcSinkConfig)this.config()).getSaveMode()) ? writer.mode(((JdbcSinkConfig)this.config()).getSaveMode()) : BoxedUnit.UNIT;
        this.logger().info(new StringBuilder(54).append("Save data to jdbc url: ").append(((JdbcSinkConfig)this.config()).getUrl()).append(", driver: ").append(((JdbcSinkConfig)this.config()).getDriver()).append(", username: ").append(((JdbcSinkConfig)this.config()).getUser()).append(", table: ").append(targetTable).toString());
        writer.options((Map)((scala.collection.immutable.Map)options.elem)).save();
    }

    private void execute(Connection conn, JDBCOptions jdbcOptions, String query) {
        this.logger().info("Execute query: {}", new Object[]{query});
        try (PreparedStatement statement = conn.prepareStatement(query);){
            try {
                if (new StringOps(Predef$.MODULE$.augmentString(package$.MODULE$.SPARK_VERSION())).$greater$eq((Object)"2.4")) {
                    int queryTimeout = BoxesRunTime.unboxToInt((Object)ClassUtils$.MODULE$.getFieldVal((Object)jdbcOptions, "queryTimeout"));
                    statement.setQueryTimeout(queryTimeout);
                }
                int rows = statement.executeUpdate();
                this.logger().info("{} rows affected", (Object)BoxesRunTime.boxToInteger((int)rows));
            }
            catch (Exception e) {
                this.logger().error("Execute query failed. ", (Throwable)e);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$output$4(JdbcSink $this, Connection conn$1, JDBCOptions jdbcOptions$1, String query) {
        $this.logger().info(new StringBuilder(19).append("Execute pre query: ").append(query).toString());
        $this.execute(conn$1, jdbcOptions$1, query);
    }

    public static final /* synthetic */ void $anonfun$output$3(JdbcSink $this, ObjectRef options$1, Iterator x$1) {
        JDBCOptions jdbcOptions = new JDBCOptions((scala.collection.immutable.Map)options$1.elem);
        try (Connection conn = DriverManager.getConnection(((JdbcSinkConfig)$this.config()).getUrl(), ((JdbcSinkConfig)$this.config()).getUser(), ((JdbcSinkConfig)$this.config()).getPassword());){
            try {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((JdbcSinkConfig)$this.config()).getPreQueries()).asScala()).foreach((Function1 & Serializable & scala.Serializable)query -> {
                    JdbcSink.$anonfun$output$4($this, conn, jdbcOptions, query);
                    return BoxedUnit.UNIT;
                });
            }
            catch (Exception e) {
                $this.logger().error("Execute preQueries failed. ", (Throwable)e);
            }
        }
    }

    public JdbcSink() {
        DataCalcPlugin.$init$(this);
        Logging.$init$((Logging)this);
    }
}

