/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.label.builder;

import java.io.InputStream;
import java.lang.reflect.Type;
import org.apache.linkis.manager.label.builder.AbstractGenericLabelBuilder;
import org.apache.linkis.manager.label.builder.LabelBuilder;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.exception.LabelErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelBuilderAdapter
extends AbstractGenericLabelBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(LabelBuilderAdapter.class);
    private LabelBuilder actualBuilder;

    public LabelBuilderAdapter(LabelBuilder labelBuilder) {
        this.actualBuilder = labelBuilder;
    }

    @Override
    public boolean canBuild(String labelKey, Class<?> labelClass) {
        return null != labelKey && this.actualBuilder.canBuild(labelKey);
    }

    @Override
    public <T extends Label<?>> T build(String labelKey, Object valueObj, Class<?> labelClass, Type ... valueTypes) throws LabelErrorException {
        Label<?> label = this.actualBuilder.build(labelKey, valueObj);
        return (T)(this.checkLabelBuilt(label, labelClass, valueTypes) ? label : null);
    }

    @Override
    public <T extends Label<?>> T build(String labelKey, Object valueObj, Class<T> labelType) throws LabelErrorException {
        Label<?> label = this.actualBuilder.build(labelKey, valueObj);
        return (T)(this.checkLabelBuilt(label, labelType, new Type[0]) ? label : null);
    }

    @Override
    public <T extends Label<?>> T build(String labelKey, InputStream valueInput, Class<?> labelClass, Type ... valueTypes) throws LabelErrorException {
        Label<?> label = this.actualBuilder.build(labelKey, valueInput);
        return (T)(this.checkLabelBuilt(label, labelClass, new Type[0]) ? label : null);
    }

    @Override
    public <T extends Label<?>> T build(String labelKey, InputStream valueInput, Class<T> labelClass) throws LabelErrorException {
        Label<?> label = this.actualBuilder.build(labelKey, valueInput);
        return (T)(this.checkLabelBuilt(label, labelClass, new Type[0]) ? label : null);
    }

    @Override
    public int getOrder() {
        return this.actualBuilder.getOrder();
    }

    private boolean checkLabelBuilt(Label<?> labelBuilt, Class<?> labelType, Type ... valueType) {
        Class<?>[] actualValueTypes;
        if (null == labelBuilt || !labelType.isAssignableFrom(labelBuilt.getClass())) {
            LOG.debug("Label built doesn't have the same type as label type: [" + labelType.getSimpleName() + "], rebuild it");
            return false;
        }
        if (valueType.length > 0 && null != (actualValueTypes = this.findActualLabelValueClass(labelBuilt.getClass()))) {
            for (int i = 0; i < Math.min(valueType.length, actualValueTypes.length); ++i) {
                if (actualValueTypes[i] == valueType[i]) continue;
                return false;
            }
        }
        return true;
    }
}

