/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.service;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.linkis.hadoop.common.utils.HDFSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsConnection
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsConnection.class);
    private final Configuration hadoopConf;
    private final FileSystem fs;

    public HdfsConnection(String scheme, String operator, String clusterLabel, boolean cache) throws IOException {
        this.hadoopConf = HDFSUtils.getConfigurationByLabel((String)operator, (String)clusterLabel);
        this.fs = this.createFileSystem(operator, this.hadoopConf, cache);
    }

    public HdfsConnection(String scheme, String operator, Map<String, String> configuration, boolean cache) {
        if (Objects.nonNull(configuration)) {
            this.hadoopConf = new Configuration();
            configuration.forEach((arg_0, arg_1) -> ((Configuration)this.hadoopConf).set(arg_0, arg_1));
        } else {
            this.hadoopConf = HDFSUtils.getConfiguration((String)operator);
        }
        this.fs = this.createFileSystem(operator, this.hadoopConf, cache);
    }

    @Override
    public void close() throws IOException {
        this.fs.close();
    }

    public String getSchema() {
        return this.fs.getScheme();
    }

    public Configuration getConfiguration() {
        return this.hadoopConf;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    private FileSystem createFileSystem(String operator, Configuration hadoopConf, boolean cache) {
        if (!cache) {
            hadoopConf.set("fs.hdfs.impl.disable.cache", "true");
        }
        return HDFSUtils.createFileSystem((String)operator, (Configuration)hadoopConf);
    }
}

