/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.interceptor.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.entrance.exception.EntranceErrorCode;
import org.apache.linkis.entrance.interceptor.exception.UserCreatorIPCheckException;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.governance.common.protocol.conf.UserIpRequest;
import org.apache.linkis.governance.common.protocol.conf.UserIpResponse;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.Sender$;
import org.slf4j.Logger;
import scala.Function0;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class UserCreatorIPCheckUtils$
implements Logging {
    public static UserCreatorIPCheckUtils$ MODULE$;
    private final LoadingCache<String, String> configCache;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new UserCreatorIPCheckUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        UserCreatorIPCheckUtils$ userCreatorIPCheckUtils$ = this;
        synchronized (userCreatorIPCheckUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private LoadingCache<String, String> configCache() {
        return this.configCache;
    }

    public JobRequest checkUserIp(JobRequest jobRequest, StringBuilder logAppender) {
        String jobIp = jobRequest.getSource().getOrDefault("requestIP", "");
        this.logger().debug(new StringBuilder(26).append("start to checkTenantLabel ").append(jobIp).toString());
        if (StringUtils.isNotBlank((CharSequence)jobIp)) {
            JobRequest jobRequest2 = jobRequest;
            if (jobRequest2 != null) {
                JobRequest jobRequest3 = jobRequest2;
                if (StringUtils.isBlank((CharSequence)jobRequest3.getSubmitUser())) {
                    throw new UserCreatorIPCheckException(EntranceErrorCode.USER_NULL_EXCEPTION.getErrCode(), EntranceErrorCode.USER_NULL_EXCEPTION.getDesc());
                }
                String cacheIp = "";
                cacheIp = (String)this.configCache().get((Object)LabelUtil$.MODULE$.getUserCreatorLabel(jobRequest3.getLabels()).getStringValue().toLowerCase());
                if (StringUtils.isBlank((CharSequence)cacheIp)) {
                    cacheIp = (String)this.configCache().get((Object)new StringBuilder(2).append("*-").append(LabelUtil$.MODULE$.getUserCreatorLabel(jobRequest3.getLabels()).getCreator().toLowerCase()).toString());
                }
                this.logger().info(new StringBuilder(30).append("get cache cacheIp:").append(cacheIp).append(",jobRequest:").append(jobRequest3.getId()).toString());
                if (StringUtils.isNotBlank((CharSequence)cacheIp)) {
                    if (!cacheIp.equals("*") && !cacheIp.contains(jobIp)) {
                        this.logger().warn(" User IP blocking failed cacheIp :{} ,jobRequest:{} ,requestIp:{}", new Object[]{cacheIp, jobRequest3.getId(), jobIp});
                        throw new UserCreatorIPCheckException(EntranceErrorCode.USER_IP_EXCEPTION.getErrCode(), EntranceErrorCode.USER_IP_EXCEPTION.getDesc());
                    }
                }
            }
        }
        return jobRequest;
    }

    private UserCreatorIPCheckUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.configCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite((long)BoxesRunTime.unboxToInt((Object)EntranceConfiguration$.MODULE$.USER_PARALLEL_REFLESH_TIME().getValue()), TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String userCreatorLabel) {
                String cacheValue;
                block0: {
                    cacheValue = (String)Utils$.MODULE$.tryAndWarn((Function0 & Serializable & scala.Serializable)() -> {
                        String creator;
                        String user;
                        Sender sender = Sender$.MODULE$.getSender((String)Configuration$.MODULE$.CLOUD_CONSOLE_CONFIGURATION_SPRING_APPLICATION_NAME().getValue());
                        Object object = sender.ask((Object)new UserIpRequest(user = userCreatorLabel.split("-")[0], creator = userCreatorLabel.split("-")[1]));
                        if (object instanceof UserIpResponse) {
                            UserIpResponse userIpResponse = (UserIpResponse)object;
                            return userIpResponse.ip();
                        }
                        UserCreatorIPCheckUtils$.MODULE$.logger().warn(new StringBuilder(46).append("UserIpCache user ").append(user).append(" creator ").append(creator).append(" data loading failed").toString());
                        return "";
                    }, UserCreatorIPCheckUtils$.MODULE$.logger());
                    if (!StringUtils.isBlank((CharSequence)cacheValue)) break block0;
                    UserCreatorIPCheckUtils$.MODULE$.logger().warn("UserIpCache data loading failed , plaese check warn log");
                    cacheValue = "";
                }
                return cacheValue;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$load$1(java.lang.String )}, serializedLambda);
            }
        });
    }
}

