/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.linkis.storage.excel.XlsUtils;
import org.apache.linkis.storage.excel.XlsxUtils;

public class ExcelStorageReader {
    public static List<List<String>> getExcelTitle(InputStream in, File file, Boolean hasHeader, String suffix) throws Exception {
        List<List<String>> res;
        if (".xls".equalsIgnoreCase(suffix)) {
            if (in == null) {
                in = new FileInputStream(file);
            }
            res = XlsUtils.getBasicInfo(in);
        } else {
            res = XlsxUtils.getBasicInfo(in, file);
        }
        if (res == null && res.size() < 2) {
            throw new Exception("There is a problem with the file format(\u6587\u4ef6\u683c\u5f0f\u6709\u95ee\u9898)");
        }
        ArrayList<String> headerType = new ArrayList<String>();
        List<String> header = res.get(1);
        if (hasHeader.booleanValue()) {
            for (int i = 0; i < header.size(); ++i) {
                headerType.add("string");
            }
        } else {
            ArrayList<String> headerNew = new ArrayList<String>();
            for (int i = 0; i < header.size(); ++i) {
                headerNew.add("col_" + (i + 1));
                headerType.add("string");
            }
            res.set(1, headerNew);
        }
        res.add(headerType);
        return res;
    }
}

