/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.client.service;

import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.cs.client.ContextClient;
import org.apache.linkis.cs.client.builder.ContextClientFactory;
import org.apache.linkis.cs.client.service.DefaultSearchService;
import org.apache.linkis.cs.client.service.LinkisJobDataService;
import org.apache.linkis.cs.client.service.SearchService;
import org.apache.linkis.cs.client.utils.SerializeHelper;
import org.apache.linkis.cs.common.entity.data.LinkisJobData;
import org.apache.linkis.cs.common.entity.source.CommonContextValue;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.entity.source.ContextValue;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkisJobDataServiceImpl
implements LinkisJobDataService {
    private static final Logger logger = LoggerFactory.getLogger(LinkisJobDataServiceImpl.class);
    private SearchService searchService = DefaultSearchService.getInstance();
    private static LinkisJobDataService linkisJobDataService;

    private LinkisJobDataServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LinkisJobDataService getInstance() {
        if (null != linkisJobDataService) return linkisJobDataService;
        Class<LinkisJobDataServiceImpl> clazz = LinkisJobDataServiceImpl.class;
        synchronized (LinkisJobDataServiceImpl.class) {
            if (null != linkisJobDataService) return linkisJobDataService;
            linkisJobDataService = new LinkisJobDataServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return linkisJobDataService;
        }
    }

    @Override
    public LinkisJobData getLinkisJobData(String contextIDStr, String contextKeyStr) throws CSErrorException {
        if (StringUtils.isBlank((CharSequence)contextIDStr) || StringUtils.isBlank((CharSequence)contextKeyStr)) {
            logger.warn("contextIDStr or nodeName cannot null");
            return null;
        }
        try {
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            ContextKey contextKey = SerializeHelper.deserializeContextKey(contextKeyStr);
            LinkisJobData jobData = this.searchService.getContextValue(contextID, contextKey, LinkisJobData.class);
            if (null != jobData) {
                logger.info("contextID: {} and contextKeyStr: {} succeed to getLinkisJobData  {}", new Object[]{contextID.getContextId(), contextKeyStr, jobData.getJobID()});
            }
            return jobData;
        }
        catch (ErrorException e) {
            logger.error("Deserialize failed, invalid contextId : " + contextIDStr + ", or contextKey : " + contextKeyStr + ", e : " + e.getMessage());
            logger.error("exception ", (Throwable)e);
            throw new CSErrorException(70112, "Deserialize failed, invalid contextId : " + contextIDStr + ", or contextKey : " + contextKeyStr + ", e : " + e.getMessage());
        }
    }

    @Override
    public void putLinkisJobData(String contextIDStr, String contextKeyStr, LinkisJobData linkisJobData) throws CSErrorException {
        ContextClient contextClient = ContextClientFactory.getOrCreateContextClient();
        try {
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            ContextKey contextKey = SerializeHelper.deserializeContextKey(contextKeyStr);
            CommonContextValue contextValue = new CommonContextValue();
            contextValue.setValue((Object)linkisJobData);
            contextClient.update(contextID, contextKey, (ContextValue)contextValue);
            logger.info("contextID: {} and contextKeyStr: {} succeed to putLinkisJobData  {}", new Object[]{contextID.getContextId(), contextKeyStr, linkisJobData.getJobID()});
        }
        catch (ErrorException e) {
            logger.error("Deserialize error. e ", (Throwable)e);
            throw new CSErrorException(70112, "Deserialize error. e : " + e.getDesc());
        }
    }
}

