/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.label.entity;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.manager.label.entity.CombinedLabel;
import org.apache.linkis.manager.label.entity.Feature;
import org.apache.linkis.manager.label.entity.Label;

public class CombinedLabelImpl
implements CombinedLabel {
    private List<Label<?>> value;
    private Feature feature;

    public CombinedLabelImpl() {
    }

    public CombinedLabelImpl(List<Label<?>> value) {
        value.sort(Comparator.comparing(Label::getLabelKey));
        Collections.reverse(value);
        this.value = value;
    }

    @Override
    public String getLabelKey() {
        if (this.isEmpty().booleanValue()) {
            return "combined_";
        }
        List keyList = this.getValue().stream().map(Label::getLabelKey).collect(Collectors.toList());
        String labelKey = "combined_" + StringUtils.join(keyList, (String)"_");
        return labelKey;
    }

    @Override
    public List<Label<?>> getValue() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        if (this.isEmpty().booleanValue()) {
            return null;
        }
        return this.getValue().stream().map(Label::getStringValue).collect(Collectors.joining(","));
    }

    @Override
    public Feature getFeature() {
        return this.feature;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    @Override
    public Boolean isEmpty() {
        return CollectionUtils.isEmpty((Collection)this.getValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof CombinedLabel) {
            return this.getStringValue().equals(((Label)obj).getStringValue());
        }
        return false;
    }

    public String toString() {
        return "CombinedLabelImpl{key=" + this.getLabelKey() + "value=" + this.getStringValue() + '}';
    }
}

