/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.command.fitter;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.entity.command.CmdOption;
import org.apache.linkis.cli.application.entity.command.CmdTemplate;
import org.apache.linkis.cli.application.entity.command.CmdType;
import org.apache.linkis.cli.application.exception.CommandException;
import org.apache.linkis.cli.application.exception.LinkisClientRuntimeException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.command.fitter.Fitter;
import org.apache.linkis.cli.application.interactor.command.fitter.FitterResult;
import org.apache.linkis.cli.application.interactor.command.fitter.FitterUtils;
import org.apache.linkis.cli.application.interactor.command.template.option.Flag;
import org.apache.linkis.cli.application.interactor.command.template.option.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFitter
implements Fitter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFitter.class);

    @Override
    public abstract FitterResult fit(String[] var1, CmdTemplate var2) throws LinkisClientRuntimeException;

    protected CmdTemplate doFit(String[] args, CmdTemplate templateCopy, List<String> remains) throws LinkisClientRuntimeException {
        String msg = "Parsing command: \"{0}\" into template: \"{1}\"";
        logger.info(MessageFormat.format(msg, StringUtils.join((Object[])args, (String)" "), templateCopy.getCmdType()));
        ArrayList parameters = new ArrayList();
        for (CmdOption<?> option : templateCopy.getOptions()) {
            if (!(option instanceof Parameter)) continue;
            parameters.add(option);
        }
        this.doFit(args, 0, templateCopy.getCmdType(), templateCopy.getOptionsMap(), templateCopy.getOptions(), parameters, remains);
        return templateCopy;
    }

    private final void doFit(String[] args, int start, CmdType cmdType, Map<String, CmdOption<?>> optionsMap, List<CmdOption<?>> options, List<CmdOption<?>> parameters, List<String> remains) throws LinkisClientRuntimeException {
        this.doFit(args, start, 0, cmdType, optionsMap, options, parameters, remains);
    }

    private final void doFit(String[] args, int argIdx, int paraIdx, CmdType cmdType, Map<String, CmdOption<?>> optionsMap, List<CmdOption<?>> options, List<CmdOption<?>> parameters, List<String> remains) throws LinkisClientRuntimeException {
        if (args.length <= argIdx || args.length <= paraIdx) {
            return;
        }
        if (FitterUtils.isOption(args[argIdx]) && optionsMap.containsKey(args[argIdx])) {
            int index = this.setOptionValue(args, argIdx, cmdType, optionsMap, remains);
            this.doFit(args, index, paraIdx, cmdType, optionsMap, options, parameters, remains);
        } else {
            int index = this.setParameterValue(args, argIdx, paraIdx, parameters, remains);
            this.doFit(args, index, paraIdx + 1, cmdType, optionsMap, options, parameters, remains);
        }
    }

    private final int setOptionValue(String[] args, int index, CmdType cmdType, Map<String, CmdOption<?>> optionsMap, List<String> remains) throws LinkisClientRuntimeException {
        int next = index + 1;
        String arg = args[index];
        if (optionsMap.containsKey(args[index])) {
            CmdOption<?> cmdOption = optionsMap.get(arg);
            if (cmdOption instanceof Flag) {
                try {
                    cmdOption.setValueWithStr("true");
                }
                catch (IllegalArgumentException ie) {
                    String msg = MessageFormat.format("Illegal Arguement \"{0}\" for option \"{1}\"", args[next], cmdOption.getParamName());
                    throw new CommandException("CMD0010", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.TemplateFitErr, cmdType, msg);
                }
                return next;
            }
            if (cmdOption instanceof CmdOption) {
                if (next >= args.length || FitterUtils.isOption(args[next])) {
                    String msg = MessageFormat.format("Cannot parse command: option \"{0}\" is specified without value.", arg);
                    throw new CommandException("CMD0011", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.TemplateFitErr, cmdType, msg);
                }
                try {
                    cmdOption.setValueWithStr(args[next]);
                }
                catch (IllegalArgumentException ie) {
                    String msg = MessageFormat.format("Illegal Arguement \"{0}\" for option \"{1}\". Msg: {2}", args[next], cmdOption.getParamName(), ie.getMessage());
                    throw new CommandException("CMD0010", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.TemplateFitErr, cmdType, msg);
                }
                return next + 1;
            }
            throw new CommandException("CMD0010", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.TemplateFitErr, "Failed to set option value: optionMap contains objects that is not Option!");
        }
        remains.add(arg);
        if (next < args.length && !FitterUtils.isOption(args[next])) {
            remains.add(args[next]);
            return next + 1;
        }
        return next;
    }

    private final int setParameterValue(String[] args, int argIdx, int paraIdx, List<CmdOption<?>> parameters, List<String> remains) throws LinkisClientRuntimeException {
        if (parameters.size() <= paraIdx) {
            remains.add(args[argIdx]);
            return argIdx + 1;
        }
        CmdOption<?> cmdOption = parameters.get(paraIdx);
        if (!(cmdOption instanceof Parameter)) {
            throw new CommandException("CMD001", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.TemplateFitErr, "Failed to set param value: parameters contains objects that is not Parameter!");
        }
        Parameter param = (Parameter)cmdOption;
        if (param.accepctArrayValue()) {
            Object[] args2 = Arrays.copyOfRange(args, argIdx, args.length);
            param.setValueWithStr(StringUtils.join((Object[])args2, (String)"@#@"));
            return args.length;
        }
        parameters.get(paraIdx).setValueWithStr(args[argIdx]);
        return argIdx + 1;
    }
}

