/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.jpa.converter;

import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.catalog.api.Attribute;
import org.apache.logging.log4j.catalog.api.Constraint;
import org.apache.logging.log4j.catalog.api.plugins.ConstraintPlugins;
import org.apache.logging.log4j.catalog.jpa.model.AttributeModel;
import org.apache.logging.log4j.catalog.jpa.model.ConstraintModel;
import org.modelmapper.AbstractConverter;
import org.springframework.stereotype.Component;

@Component
public class AttributeModelConverter
extends AbstractConverter<AttributeModel, Attribute> {
    public Attribute convert(AttributeModel model) {
        Attribute attribute = new Attribute();
        attribute.setName(model.getName());
        attribute.setDisplayName(model.getDisplayName());
        attribute.setDescription(model.getDescription());
        attribute.setAliases(model.getAliases());
        attribute.setId(model.getId());
        attribute.setCatalogId(model.getCatalogId());
        attribute.setIndexed(model.isIndexed());
        attribute.setSortable(model.isSortable());
        attribute.setRequestContext(model.isRequestContext());
        attribute.setRequired(model.isRequired());
        attribute.setDataType(model.getDataType());
        Set<ConstraintModel> constraintModels = model.getConstraints();
        HashSet<Constraint> constraints = new HashSet<Constraint>();
        if (constraintModels != null) {
            for (ConstraintModel constraintModel : constraintModels) {
                Constraint constraint = new Constraint();
                constraint.setId(constraintModel.getId());
                constraint.setConstraintType(ConstraintPlugins.getInstance().findByName(constraintModel.getConstraintType()));
                constraint.setValue(constraintModel.getValue());
                constraints.add(constraint);
            }
        }
        attribute.setConstraints(constraints);
        return attribute;
    }
}

