/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.DocumentDescription;
import org.apache.manifoldcf.crawler.interfaces.DocumentSetAndFlags;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.system.CleanupQueuedDocument;
import org.apache.manifoldcf.crawler.system.DocCleanupResetManager;
import org.apache.manifoldcf.crawler.system.DocumentCleanupQueue;
import org.apache.manifoldcf.crawler.system.DocumentCleanupSet;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class DocumentCleanupStufferThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: DocumentCleanupStufferThread.java 1545624 2013-11-26 11:45:53Z kwright $";
    protected final DocumentCleanupQueue documentCleanupQueue;
    protected final DocCleanupResetManager resetManager;
    protected final int n;
    protected final String processID;

    public DocumentCleanupStufferThread(DocumentCleanupQueue documentCleanupQueue, int n, DocCleanupResetManager resetManager, String processID) throws ManifoldCFException {
        this.documentCleanupQueue = documentCleanupQueue;
        this.n = n;
        this.resetManager = resetManager;
        this.processID = processID;
        this.setName("Document cleanup stuffer thread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        this.resetManager.registerMe();
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IRepositoryConnectionManager mgr = RepositoryConnectionManagerFactory.make(threadContext);
            IJobManager jobManager = JobManagerFactory.make(threadContext);
            ArrayList docList = new ArrayList();
            IDBInterface database = DBInterfaceFactory.make((IThreadContext)threadContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
            int deleteChunkSize = database.getMaxInClause();
            while (true) {
                try {
                    while (true) {
                        int k;
                        this.resetManager.waitForReset(threadContext);
                        if (!this.documentCleanupQueue.checkIfEmpty(this.n)) {
                            ManifoldCF.sleep((long)100L);
                            continue;
                        }
                        Logging.threads.debug((Object)"Document cleanup stuffer thread woke up");
                        long currentTime = System.currentTimeMillis();
                        DocumentSetAndFlags documentsToClean = jobManager.getNextCleanableDocuments(this.processID, deleteChunkSize, currentTime);
                        DocumentDescription[] descs = documentsToClean.getDocumentSet();
                        boolean[] removeFromIndex = documentsToClean.getFlags();
                        if (descs.length == 0) {
                            Logging.threads.debug((Object)"Document cleanup stuffer thread found nothing to do");
                            ManifoldCF.sleep((long)1000L);
                            continue;
                        }
                        if (Logging.threads.isDebugEnabled()) {
                            Logging.threads.debug((Object)("Document cleanup stuffer thread found " + Integer.toString(descs.length) + " documents"));
                        }
                        HashMap<Long, ArrayList<CleanupQueuedDocument>> jobMap = new HashMap<Long, ArrayList<CleanupQueuedDocument>>();
                        for (k = 0; k < descs.length; ++k) {
                            CleanupQueuedDocument x = new CleanupQueuedDocument(descs[k], removeFromIndex[k]);
                            Long jobID = descs[k].getJobID();
                            ArrayList<CleanupQueuedDocument> y = (ArrayList<CleanupQueuedDocument>)jobMap.get(jobID);
                            if (y == null) {
                                y = new ArrayList<CleanupQueuedDocument>();
                                jobMap.put(jobID, y);
                            }
                            y.add(x);
                        }
                        for (Long jobID : jobMap.keySet()) {
                            IJobDescription jobDescription = jobManager.load(jobID, true);
                            List y = (List)jobMap.get(jobID);
                            CleanupQueuedDocument[] docDescs = new CleanupQueuedDocument[y.size()];
                            for (k = 0; k < docDescs.length; ++k) {
                                docDescs[k] = (CleanupQueuedDocument)y.get(k);
                            }
                            DocumentCleanupSet set = new DocumentCleanupSet(docDescs, jobDescription);
                            this.documentCleanupQueue.addDocuments(set);
                        }
                        DocumentCleanupStufferThread.yield();
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        this.resetManager.noteEvent();
                        Logging.threads.error((Object)"Cleanup stuffer thread aborting and restarting due to database connection reset", (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) continue;
                    System.exit(1);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    System.exit(-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("DocumentCleanupStufferThread initialization error tossed: " + e.getMessage()), e);
            System.exit(-300);
        }
    }
}

