/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.FullBox;
import com.coremedia.iso.boxes.SchemeInformationBox;
import com.googlecode.mp4parser.AbstractContainerBox;
import com.googlecode.mp4parser.DataSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class ItemProtectionBox
extends AbstractContainerBox
implements FullBox {
    public static final String TYPE = "ipro";
    private int version;
    private int flags;

    public ItemProtectionBox() {
        super(TYPE);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public SchemeInformationBox getItemProtectionScheme() {
        if (!this.getBoxes(SchemeInformationBox.class).isEmpty()) {
            return this.getBoxes(SchemeInformationBox.class).get(0);
        }
        return null;
    }

    public void parse(DataSource dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        ByteBuffer versionFlagNumOfChildBoxes = ByteBuffer.allocate(6);
        dataSource.read(versionFlagNumOfChildBoxes);
        versionFlagNumOfChildBoxes.rewind();
        this.version = IsoTypeReader.readUInt8(versionFlagNumOfChildBoxes);
        this.flags = IsoTypeReader.readUInt24(versionFlagNumOfChildBoxes);
        this.parseContainer(dataSource, contentSize - 6L, boxParser);
    }

    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write(this.getHeader());
        ByteBuffer versionFlagNumOfChildBoxes = ByteBuffer.allocate(6);
        IsoTypeWriter.writeUInt8(versionFlagNumOfChildBoxes, this.version);
        IsoTypeWriter.writeUInt24(versionFlagNumOfChildBoxes, this.flags);
        IsoTypeWriter.writeUInt16(versionFlagNumOfChildBoxes, this.getBoxes().size());
        writableByteChannel.write((ByteBuffer)versionFlagNumOfChildBoxes.rewind());
        this.writeContainer(writableByteChannel);
    }

    public long getSize() {
        long s = this.getContainerSize();
        long t = 6L;
        return s + t + (long)(this.largeBox || s + t >= 0x100000000L ? 16 : 8);
    }
}

