/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ClearScrollRequest
extends ActionRequest<ClearScrollRequest> {
    private List<String> scrollIds;

    public List<String> getScrollIds() {
        return this.scrollIds;
    }

    public void setScrollIds(List<String> scrollIds) {
        this.scrollIds = scrollIds;
    }

    public void addScrollId(String scrollId) {
        if (this.scrollIds == null) {
            this.scrollIds = Lists.newArrayList();
        }
        this.scrollIds.add(scrollId);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.scrollIds == null || this.scrollIds.isEmpty()) {
            validationException = ValidateActions.addValidationError("no scroll ids specified", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.scrollIds = Arrays.asList(in.readStringArray());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.scrollIds == null) {
            out.writeVInt(0);
        } else {
            out.writeStringArray(this.scrollIds.toArray(new String[this.scrollIds.size()]));
        }
    }
}

