/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.broadcast.BroadcastOperationThreading;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class BroadcastOperationRequest<T extends BroadcastOperationRequest>
extends ActionRequest<T> {
    protected String[] indices;
    private BroadcastOperationThreading operationThreading = BroadcastOperationThreading.THREAD_PER_SHARD;
    private IndicesOptions indicesOptions = IndicesOptions.strict();

    protected BroadcastOperationRequest() {
    }

    protected BroadcastOperationRequest(String[] indices) {
        this.indices = indices;
    }

    public String[] indices() {
        return this.indices;
    }

    public final T indices(String ... indices) {
        this.indices = indices;
        return (T)this;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public BroadcastOperationThreading operationThreading() {
        return this.operationThreading;
    }

    public final T operationThreading(BroadcastOperationThreading operationThreading) {
        this.operationThreading = operationThreading;
        return (T)this;
    }

    public T operationThreading(String operationThreading) {
        return this.operationThreading(BroadcastOperationThreading.fromString(operationThreading, this.operationThreading));
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public final T indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return (T)this;
    }

    protected void beforeStart() {
    }

    protected void beforeLocalFork() {
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        out.writeByte(this.operationThreading.id());
        this.indicesOptions.writeIndicesOptions(out);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        this.operationThreading = BroadcastOperationThreading.fromId(in.readByte());
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }
}

