/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.local.state.shards;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.local.state.meta.LocalGatewayMetaState;
import org.elasticsearch.gateway.local.state.shards.ShardStateInfo;
import org.elasticsearch.gateway.local.state.shards.TransportNodesListGatewayStartedShards;
import org.elasticsearch.index.shard.ShardId;

public class LocalGatewayShardsState
extends AbstractComponent
implements ClusterStateListener {
    private final NodeEnvironment nodeEnv;
    private final LocalGatewayMetaState metaState;
    private volatile Map<ShardId, ShardStateInfo> currentState = Maps.newHashMap();

    @Inject
    public LocalGatewayShardsState(Settings settings, NodeEnvironment nodeEnv, TransportNodesListGatewayStartedShards listGatewayStartedShards, LocalGatewayMetaState metaState) throws Exception {
        super(settings);
        this.nodeEnv = nodeEnv;
        this.metaState = metaState;
        listGatewayStartedShards.initGateway(this);
        if (DiscoveryNode.dataNode(settings)) {
            try {
                this.pre019Upgrade();
                long start = System.currentTimeMillis();
                this.currentState = this.loadShardsStateInfo();
                this.logger.debug("took {} to load started shards state", TimeValue.timeValueMillis(System.currentTimeMillis() - start));
            }
            catch (Exception e) {
                this.logger.error("failed to read local state (started shards), exiting...", e, new Object[0]);
                throw e;
            }
        }
    }

    public Map<ShardId, ShardStateInfo> currentStartedShards() {
        return this.currentState;
    }

    public ShardStateInfo loadShardInfo(ShardId shardId) throws Exception {
        return this.loadShardStateInfo(shardId);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().disableStatePersistence()) {
            return;
        }
        if (!event.state().nodes().localNode().dataNode()) {
            return;
        }
        if (!event.routingTableChanged()) {
            return;
        }
        HashMap<ShardId, ShardStateInfo> newState = Maps.newHashMap();
        newState.putAll(this.currentState);
        for (IndexRoutingTable indexRoutingTable : event.state().routingTable()) {
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                if (indexShardRoutingTable.countWithState(ShardRoutingState.STARTED) != indexShardRoutingTable.size()) continue;
                newState.remove(indexShardRoutingTable.shardId());
            }
        }
        for (ShardId shardId : this.currentState.keySet()) {
            if (event.state().metaData().hasIndex(shardId.index().name())) continue;
            newState.remove(shardId);
        }
        RoutingNode routingNode = event.state().readOnlyRoutingNodes().node(event.state().nodes().localNodeId());
        if (routingNode != null) {
            for (MutableShardRouting shardRouting : routingNode) {
                if (!shardRouting.active()) continue;
                newState.put(shardRouting.shardId(), new ShardStateInfo(shardRouting.version(), shardRouting.primary()));
            }
        }
        Iterator it = newState.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ShardId shardId = (ShardId)entry.getKey();
            ShardStateInfo shardStateInfo = (ShardStateInfo)entry.getValue();
            String writeReason = null;
            ShardStateInfo currentShardStateInfo = this.currentState.get(shardId);
            if (currentShardStateInfo == null) {
                writeReason = "freshly started, version [" + shardStateInfo.version + "]";
            } else if (currentShardStateInfo.version != shardStateInfo.version) {
                writeReason = "version changed from [" + currentShardStateInfo.version + "] to [" + shardStateInfo.version + "]";
            }
            if (writeReason == null) continue;
            try {
                this.writeShardState(writeReason, shardId, shardStateInfo, currentShardStateInfo);
            }
            catch (Exception e) {
                it.remove();
            }
        }
        this.currentState = newState;
    }

    private Map<ShardId, ShardStateInfo> loadShardsStateInfo() throws Exception {
        Set<ShardId> shardIds = this.nodeEnv.findAllShardIds();
        long highestVersion = -1L;
        HashMap<ShardId, ShardStateInfo> shardsState = Maps.newHashMap();
        for (ShardId shardId : shardIds) {
            ShardStateInfo shardStateInfo = this.loadShardStateInfo(shardId);
            if (shardStateInfo == null) continue;
            shardsState.put(shardId, shardStateInfo);
            if (shardStateInfo.version <= highestVersion) continue;
            highestVersion = shardStateInfo.version;
        }
        return shardsState;
    }

    private ShardStateInfo loadShardStateInfo(ShardId shardId) {
        long highestShardVersion = -1L;
        ShardStateInfo highestShardState = null;
        for (File shardLocation : this.nodeEnv.shardLocations(shardId)) {
            File[] stateFiles;
            File shardStateDir = new File(shardLocation, "_state");
            if (!shardStateDir.exists() || !shardStateDir.isDirectory() || (stateFiles = shardStateDir.listFiles()) == null) continue;
            for (File stateFile : stateFiles) {
                if (!stateFile.getName().startsWith("state-")) continue;
                try {
                    long version = Long.parseLong(stateFile.getName().substring("state-".length()));
                    if (version <= highestShardVersion) continue;
                    byte[] data = Streams.copyToByteArray(new FileInputStream(stateFile));
                    if (data.length == 0) {
                        this.logger.debug("[{}][{}]: not data for [" + stateFile.getAbsolutePath() + "], ignoring...", shardId.index().name(), shardId.id());
                        continue;
                    }
                    ShardStateInfo readState = this.readShardState(data);
                    if (readState == null) {
                        this.logger.debug("[{}][{}]: not data for [" + stateFile.getAbsolutePath() + "], ignoring...", shardId.index().name(), shardId.id());
                        continue;
                    }
                    assert (readState.version == version);
                    highestShardState = readState;
                    highestShardVersion = version;
                }
                catch (Exception e) {
                    this.logger.debug("[{}][{}]: failed to read [" + stateFile.getAbsolutePath() + "], ignoring...", e, shardId.index().name(), shardId.id());
                }
            }
        }
        return highestShardState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ShardStateInfo readShardState(byte[] data) throws Exception {
        XContentParser parser = null;
        try {
            parser = XContentHelper.createParser(data, 0, data.length);
            XContentParser.Token token = parser.nextToken();
            if (token == null) {
                ShardStateInfo shardStateInfo = null;
                return shardStateInfo;
            }
            long version = -1L;
            Boolean primary = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (!token.isValue()) continue;
                if ("version".equals(currentFieldName)) {
                    version = parser.longValue();
                    continue;
                }
                if (!"primary".equals(currentFieldName)) continue;
                primary = parser.booleanValue();
            }
            ShardStateInfo shardStateInfo = new ShardStateInfo(version, primary);
            return shardStateInfo;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeShardState(String reason, ShardId shardId, ShardStateInfo shardStateInfo, @Nullable ShardStateInfo previousStateInfo) throws Exception {
        this.logger.trace("[{}][{}] writing shard state, reason [{}]", shardId.index().name(), shardId.id(), reason);
        XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON, new BytesStreamOutput());
        builder.prettyPrint();
        builder.startObject();
        builder.field("version", shardStateInfo.version);
        if (shardStateInfo.primary != null) {
            builder.field("primary", (Object)shardStateInfo.primary);
        }
        builder.endObject();
        builder.flush();
        Exception lastFailure = null;
        boolean wroteAtLeastOnce = false;
        for (File shardLocation : this.nodeEnv.shardLocations(shardId)) {
            File shardStateDir = new File(shardLocation, "_state");
            FileSystemUtils.mkdirs(shardStateDir);
            File stateFile = new File(shardStateDir, "state-" + shardStateInfo.version);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(stateFile);
                BytesReference bytes = builder.bytes();
                fos.write(bytes.array(), bytes.arrayOffset(), bytes.length());
                fos.getChannel().force(true);
                fos.close();
                wroteAtLeastOnce = true;
            }
            catch (Exception e) {
                try {
                    lastFailure = e;
                }
                catch (Throwable throwable) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{fos});
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{fos});
                continue;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{fos});
        }
        if (!wroteAtLeastOnce) {
            this.logger.warn("[{}][{}]: failed to write shard state", shardId.index().name(), shardId.id(), lastFailure);
            throw new IOException("failed to write shard state for " + shardId, lastFailure);
        }
        if (previousStateInfo != null && previousStateInfo.version != shardStateInfo.version) {
            for (File shardLocation : this.nodeEnv.shardLocations(shardId)) {
                File stateFile = new File(new File(shardLocation, "_state"), "state-" + previousStateInfo.version);
                stateFile.delete();
            }
        }
    }

    private void deleteShardState(ShardId shardId) {
        File[] shardLocations;
        this.logger.trace("[{}][{}] delete shard state", shardId.index().name(), shardId.id());
        for (File shardLocation : shardLocations = this.nodeEnv.shardLocations(shardId)) {
            if (!shardLocation.exists()) continue;
            FileSystemUtils.deleteRecursively(new File(shardLocation, "_state"));
        }
    }

    private void pre019Upgrade() throws Exception {
        long index = -1L;
        File latest = null;
        for (File dataLocation : this.nodeEnv.nodeDataLocations()) {
            File[] stateFiles;
            File stateLocation = new File(dataLocation, "_state");
            if (!stateLocation.exists() || (stateFiles = stateLocation.listFiles()) == null) continue;
            for (File stateFile : stateFiles) {
                long fileIndex;
                String name;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[find_latest_state]: processing [" + stateFile.getName() + "]", new Object[0]);
                }
                if (!(name = stateFile.getName()).startsWith("shards-") || (fileIndex = Long.parseLong(name.substring(name.indexOf(45) + 1))) < index) continue;
                try {
                    byte[] data = Streams.copyToByteArray(new FileInputStream(stateFile));
                    if (data.length == 0) {
                        this.logger.debug("[upgrade]: not data for [" + name + "], ignoring...", new Object[0]);
                    }
                    this.pre09ReadState(data);
                    index = fileIndex;
                    latest = stateFile;
                }
                catch (IOException e) {
                    this.logger.warn("[upgrade]: failed to read state from [" + name + "], ignoring...", e, new Object[0]);
                }
            }
        }
        if (latest == null) {
            return;
        }
        this.logger.info("found old shards state, loading started shards from [{}] and converting to new shards state locations...", latest.getAbsolutePath());
        Map<ShardId, ShardStateInfo> shardsState = this.pre09ReadState(Streams.copyToByteArray(new FileInputStream(latest)));
        for (Map.Entry<ShardId, ShardStateInfo> entry : shardsState.entrySet()) {
            this.writeShardState("upgrade", entry.getKey(), entry.getValue(), null);
        }
        File backupFile = new File(latest.getParentFile(), "backup-" + latest.getName());
        if (!latest.renameTo(backupFile)) {
            throw new IOException("failed to rename old state to backup state [" + latest.getAbsolutePath() + "]");
        }
        for (File dataLocation : this.nodeEnv.nodeDataLocations()) {
            File[] stateFiles;
            File stateLocation = new File(dataLocation, "_state");
            if (!stateLocation.exists() || (stateFiles = stateLocation.listFiles()) == null) continue;
            for (File stateFile : stateFiles) {
                String name = stateFile.getName();
                if (!name.startsWith("shards-")) continue;
                stateFile.delete();
            }
        }
        this.logger.info("conversion to new shards state location and format done, backup create at [{}]", backupFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ShardId, ShardStateInfo> pre09ReadState(byte[] data) throws IOException {
        XContentParser parser = null;
        try {
            HashMap<ShardId, ShardStateInfo> shardsState = Maps.newHashMap();
            parser = XContentHelper.createParser(data, 0, data.length);
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            if (token == null) {
                HashMap<ShardId, ShardStateInfo> hashMap = shardsState;
                return hashMap;
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token != XContentParser.Token.START_ARRAY || !"shards".equals(currentFieldName)) continue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (token != XContentParser.Token.START_OBJECT) continue;
                    String shardIndex = null;
                    int shardId = -1;
                    long version = -1L;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (!token.isValue()) continue;
                        if ("index".equals(currentFieldName)) {
                            shardIndex = parser.text();
                            continue;
                        }
                        if ("id".equals(currentFieldName)) {
                            shardId = parser.intValue();
                            continue;
                        }
                        if (!"version".equals(currentFieldName)) continue;
                        version = parser.longValue();
                    }
                    shardsState.put(new ShardId(shardIndex, shardId), new ShardStateInfo(version, null));
                }
            }
            HashMap<ShardId, ShardStateInfo> hashMap = shardsState;
            return hashMap;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }
}

