/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.id.simple;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.hppc.ObjectIntOpenHashMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.UTF8SortedAsUnicodeComparator;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.id.IdCache;
import org.elasticsearch.index.cache.id.IdReaderCache;
import org.elasticsearch.index.cache.id.simple.SimpleIdReaderCache;
import org.elasticsearch.index.cache.id.simple.SimpleIdReaderTypeCache;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentTypeListener;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.ShardUtils;
import org.elasticsearch.index.shard.service.IndexShard;

public class SimpleIdCache
extends AbstractIndexComponent
implements IdCache,
SegmentReader.CoreClosedListener,
DocumentTypeListener {
    private final boolean reuse;
    private final ConcurrentMap<Object, SimpleIdReaderCache> idReaders;
    private final NavigableSet<HashedBytesArray> parentTypes;
    IndexService indexService;

    @Inject
    public SimpleIdCache(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
        this.reuse = this.componentSettings.getAsBoolean("reuse", (Boolean)false);
        this.idReaders = ConcurrentCollections.newConcurrentMap();
        this.parentTypes = new TreeSet<BytesReference>(UTF8SortedAsUnicodeComparator.utf8SortedAsUnicodeSortOrder);
    }

    @Override
    public void setIndexService(IndexService indexService) {
        this.indexService = indexService;
        indexService.mapperService().addTypeListener(this);
    }

    @Override
    public void close() throws ElasticsearchException {
        this.indexService.mapperService().removeTypeListener(this);
        this.clear();
    }

    @Override
    public void clear() {
        HashMap<Object, SimpleIdReaderCache> copy = new HashMap<Object, SimpleIdReaderCache>(this.idReaders);
        for (Map.Entry entry : copy.entrySet()) {
            SimpleIdReaderCache removed = (SimpleIdReaderCache)this.idReaders.remove(entry.getKey());
            if (removed == null) continue;
            this.onRemoval(removed);
        }
    }

    public void onClose(Object coreCacheKey) {
        this.clear(coreCacheKey);
    }

    @Override
    public void clear(Object coreCacheKey) {
        SimpleIdReaderCache removed = (SimpleIdReaderCache)this.idReaders.remove(coreCacheKey);
        if (removed != null) {
            this.onRemoval(removed);
        }
    }

    @Override
    public IdReaderCache reader(AtomicReader reader) {
        return (IdReaderCache)this.idReaders.get(reader.getCoreCacheKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void refresh(List<AtomicReaderContext> atomicReaderContexts) throws IOException {
        block22: {
            if (!this.refreshNeeded(atomicReaderContexts)) break block22;
            var2_2 = this.idReaders;
            synchronized (var2_2) {
                if (!this.refreshNeeded(atomicReaderContexts)) {
                    return;
                }
                builders = new HashMap<Object, Map<String, TypeBuilder>>();
                cacheToReader = new HashMap<Object, AtomicReader>();
                block3: for (AtomicReaderContext context : atomicReaderContexts) {
                    reader = context.reader();
                    if (!this.refreshNeeded(context)) continue;
                    if (reader instanceof SegmentReader) {
                        ((SegmentReader)reader).addCoreClosedListener((SegmentReader.CoreClosedListener)this);
                    }
                    readerBuilder = new HashMap<K, V>();
                    builders.put(reader.getCoreCacheKey(), readerBuilder);
                    cacheToReader.put(reader.getCoreCacheKey(), context.reader());
                    terms = reader.terms("_uid");
                    if (terms == null) continue;
                    termsEnum = terms.iterator(null);
                    docsEnum = null;
                    term = termsEnum.next();
                    block4: while (term != null) {
                        typeAndId = Uid.splitUidIntoTypeAndId(term);
                        if (this.parentTypes.contains(typeAndId[0])) ** GOTO lbl38
                        while ((nextParent = this.parentTypes.ceiling(typeAndId[0])) != null && (status = termsEnum.seekCeil(nextParent.toBytesRef())) != TermsEnum.SeekStatus.END) {
                            if (status == TermsEnum.SeekStatus.NOT_FOUND) {
                                term = termsEnum.term();
                                typeAndId = Uid.splitUidIntoTypeAndId(term);
                            } else if (status == TermsEnum.SeekStatus.FOUND) {
                                if (!SimpleIdCache.$assertionsDisabled) {
                                    throw new AssertionError((Object)"Seek status should never be FOUND, because we seek only the type part");
                                }
                                term = termsEnum.term();
                                typeAndId = Uid.splitUidIntoTypeAndId(term);
                            }
                            if (!this.parentTypes.contains(typeAndId[0])) continue;
lbl38:
                            // 2 sources

                            if ((typeBuilder = (TypeBuilder)readerBuilder.get(type = typeAndId[0].toUtf8())) == null) {
                                typeBuilder = new TypeBuilder((IndexReader)reader);
                                readerBuilder.put(type, typeBuilder);
                            }
                            idAsBytes = this.checkIfCanReuse(builders, typeAndId[1]);
                            docsEnum = termsEnum.docs(null, docsEnum, 0);
                            docId = docsEnum.nextDoc();
                            while (docId != 0x7FFFFFFF) {
                                typeBuilder.idToDoc.put(idAsBytes, docId);
                                typeBuilder.docToId[docId] = idAsBytes;
                                docId = docsEnum.nextDoc();
                            }
                            term = termsEnum.next();
                            continue block4;
                        }
                        continue block3;
                    }
                }
                for (AtomicReaderContext context : atomicReaderContexts) {
                    reader = context.reader();
                    if (!this.refreshNeeded(context)) continue;
                    readerBuilder = (Map)builders.get(reader.getCoreCacheKey());
                    terms = reader.terms("_parent");
                    if (terms == null) continue;
                    termsEnum = terms.iterator(null);
                    docsEnum = null;
                    term = termsEnum.next();
                    while (term != null) {
                        typeAndId = Uid.splitUidIntoTypeAndId(term);
                        typeBuilder = (TypeBuilder)readerBuilder.get(typeAndId[0].toUtf8());
                        if (typeBuilder == null) {
                            typeBuilder = new TypeBuilder((IndexReader)reader);
                            readerBuilder.put(typeAndId[0].toUtf8(), typeBuilder);
                        }
                        idAsBytes = this.checkIfCanReuse(builders, typeAndId[1]);
                        added = false;
                        docsEnum = termsEnum.docs(null, docsEnum, 0);
                        docId = docsEnum.nextDoc();
                        while (docId != 0x7FFFFFFF) {
                            if (!added) {
                                typeBuilder.parentIdsValues.add(idAsBytes);
                                added = true;
                            }
                            typeBuilder.parentIdsOrdinals[docId] = typeBuilder.t;
                            docId = docsEnum.nextDoc();
                        }
                        if (added) {
                            ++typeBuilder.t;
                        }
                        term = termsEnum.next();
                    }
                }
                for (Map.Entry entry : builders.entrySet()) {
                    readerKey = entry.getKey();
                    types = MapBuilder.newMapBuilder();
                    for (Map.Entry<K, V> typeBuilderEntry : ((Map)entry.getValue()).entrySet()) {
                        types.put(typeBuilderEntry.getKey(), new SimpleIdReaderTypeCache((String)typeBuilderEntry.getKey(), ((TypeBuilder)typeBuilderEntry.getValue()).idToDoc, ((TypeBuilder)typeBuilderEntry.getValue()).docToId, ((TypeBuilder)typeBuilderEntry.getValue()).parentIdsValues.toArray(new HashedBytesArray[((TypeBuilder)typeBuilderEntry.getValue()).parentIdsValues.size()]), ((TypeBuilder)typeBuilderEntry.getValue()).parentIdsOrdinals));
                    }
                    indexReader = (AtomicReader)cacheToReader.get(readerKey);
                    readerCache = new SimpleIdReaderCache(types.immutableMap(), ShardUtils.extractShardId(indexReader));
                    this.idReaders.put(readerKey, readerCache);
                    this.onCached(readerCache);
                }
            }
        }
    }

    void onCached(SimpleIdReaderCache readerCache) {
        IndexShard shard;
        if (readerCache.shardId != null && (shard = this.indexService.shard(readerCache.shardId.id())) != null) {
            shard.idCache().onCached(readerCache.sizeInBytes());
        }
    }

    void onRemoval(SimpleIdReaderCache readerCache) {
        IndexShard shard;
        if (readerCache.shardId != null && (shard = this.indexService.shard(readerCache.shardId.id())) != null) {
            shard.idCache().onRemoval(readerCache.sizeInBytes());
        }
    }

    private HashedBytesArray checkIfCanReuse(Map<Object, Map<String, TypeBuilder>> builders, HashedBytesArray idAsBytes) {
        HashedBytesArray finalIdAsBytes;
        if (this.reuse) {
            for (SimpleIdReaderCache idReaderCache : this.idReaders.values()) {
                finalIdAsBytes = idReaderCache.canReuse(idAsBytes);
                if (finalIdAsBytes == null) continue;
                return finalIdAsBytes;
            }
        }
        for (Map<String, TypeBuilder> map : builders.values()) {
            for (TypeBuilder typeBuilder : map.values()) {
                finalIdAsBytes = typeBuilder.canReuse(idAsBytes);
                if (finalIdAsBytes == null) continue;
                return finalIdAsBytes;
            }
        }
        return idAsBytes;
    }

    private boolean refreshNeeded(List<AtomicReaderContext> atomicReaderContexts) {
        for (AtomicReaderContext atomicReaderContext : atomicReaderContexts) {
            if (!this.refreshNeeded(atomicReaderContext)) continue;
            return true;
        }
        return false;
    }

    private boolean refreshNeeded(AtomicReaderContext atomicReaderContext) {
        return !this.idReaders.containsKey(atomicReaderContext.reader().getCoreCacheKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeCreate(DocumentMapper mapper) {
        ConcurrentMap<Object, SimpleIdReaderCache> concurrentMap = this.idReaders;
        synchronized (concurrentMap) {
            ParentFieldMapper parentFieldMapper = mapper.parentFieldMapper();
            if (parentFieldMapper.active() && this.parentTypes.add(new HashedBytesArray(Strings.toUTF8Bytes(parentFieldMapper.type(), new BytesRef())))) {
                this.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterRemove(DocumentMapper mapper) {
        ConcurrentMap<Object, SimpleIdReaderCache> concurrentMap = this.idReaders;
        synchronized (concurrentMap) {
            ParentFieldMapper parentFieldMapper = mapper.parentFieldMapper();
            if (parentFieldMapper.active()) {
                this.parentTypes.remove(new HashedBytesArray(Strings.toUTF8Bytes(parentFieldMapper.type(), new BytesRef())));
            }
        }
    }

    static class TypeBuilder {
        final ObjectIntOpenHashMap<HashedBytesArray> idToDoc = new ObjectIntOpenHashMap();
        final HashedBytesArray[] docToId;
        final ArrayList<HashedBytesArray> parentIdsValues = new ArrayList();
        final int[] parentIdsOrdinals;
        int t = 1;

        TypeBuilder(IndexReader reader) {
            this.parentIdsOrdinals = new int[reader.maxDoc()];
            this.parentIdsValues.add(null);
            this.docToId = new HashedBytesArray[reader.maxDoc()];
        }

        public HashedBytesArray canReuse(HashedBytesArray id) {
            if (this.idToDoc.containsKey(id)) {
                return this.idToDoc.lkey();
            }
            return id;
        }
    }
}

