/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis.gradle;

import de.thetaphi.forbiddenapis.gradle.CheckForbiddenApisExtension;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.util.DelegatingScript;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.util.GradleVersion;

public class ForbiddenApisPlugin
implements Plugin<Project> {
    private static final Logger LOG = Logging.getLogger(ForbiddenApisPlugin.class);
    public static final String FORBIDDEN_APIS_TASK_NAME = "forbiddenApis";
    public static final String FORBIDDEN_APIS_EXTENSION_NAME = "forbiddenApis";
    public static final boolean DEFAULT_DISABLE_CLASSLOADING_CACHE = ForbiddenApisPlugin.detectAndLogGradleDaemon();
    public static final GradleVersion MIN_GRADLE_VERSION = GradleVersion.version((String)"3.2");
    public static final boolean TASK_AVOIDANCE_AVAILABLE = GradleVersion.current().compareTo(GradleVersion.version((String)"4.9")) >= 0;
    public static final List<String> FORBIDDEN_APIS_EXTENSION_PROPS = ForbiddenApisPlugin.determineExtensionProps();
    private static final String GRADLE_DAEMON_PACKAGE = "org.gradle.launcher.daemon.";
    private static final String PLUGIN_INIT_SCRIPT = "plugin-init.groovy";
    private static final Class<? extends DelegatingScript> COMPILED_SCRIPT = ForbiddenApisPlugin.loadScript();

    private static Class<? extends DelegatingScript> loadScript() {
        ImportCustomizer importCustomizer = new ImportCustomizer().addStarImports(new String[]{ForbiddenApisPlugin.class.getPackage().getName()});
        final CompilerConfiguration configuration = new CompilerConfiguration().addCompilationCustomizers(new CompilationCustomizer[]{importCustomizer});
        configuration.setScriptBaseClass(DelegatingScript.class.getName());
        configuration.setSourceEncoding(StandardCharsets.UTF_8.name());
        final URL scriptUrl = ForbiddenApisPlugin.class.getResource(PLUGIN_INIT_SCRIPT);
        if (scriptUrl == null) {
            throw new RuntimeException("Cannot find resource with script: plugin-init.groovy");
        }
        return AccessController.doPrivileged(new PrivilegedAction<Class<? extends DelegatingScript>>(){

            @Override
            public Class<? extends DelegatingScript> run() {
                try {
                    GroovyClassLoader loader = new GroovyClassLoader(ForbiddenApisPlugin.class.getClassLoader(), configuration);
                    GroovyCodeSource csrc = new GroovyCodeSource(scriptUrl);
                    Class<DelegatingScript> clazz = loader.parseClass(csrc, false).asSubclass(DelegatingScript.class);
                    return clazz;
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot compile Groovy script: plugin-init.groovy");
                }
            }
        });
    }

    private static List<String> determineExtensionProps() {
        ArrayList<String> props = new ArrayList<String>();
        for (Field f : CheckForbiddenApisExtension.class.getDeclaredFields()) {
            int mods = f.getModifiers();
            if (!Modifier.isPublic(mods) || f.isSynthetic() || Modifier.isStatic(mods)) continue;
            props.add(f.getName());
        }
        return Collections.unmodifiableList(props);
    }

    private static boolean isGradleDaemon() {
        if (System.getProperty("sun.java.command", "").startsWith(GRADLE_DAEMON_PACKAGE)) {
            return true;
        }
        for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
            if (!e.getClassName().startsWith(GRADLE_DAEMON_PACKAGE)) continue;
            return true;
        }
        return false;
    }

    private static boolean detectAndLogGradleDaemon() {
        boolean daemon = ForbiddenApisPlugin.isGradleDaemon();
        if (daemon) {
            LOG.info("You are running forbidden-apis in the Gradle Daemon; disabling classloading cache by default to work around resource leak.");
        }
        return daemon;
    }

    public void apply(Project project) {
        DelegatingScript script;
        if (GradleVersion.current().compareTo(MIN_GRADLE_VERSION) < 0) {
            throw new GradleException("Forbiddenapis plugin requires at least " + MIN_GRADLE_VERSION + ", running version is " + GradleVersion.current());
        }
        try {
            script = COMPILED_SCRIPT.newInstance();
        }
        catch (Exception e) {
            throw new GradleException("Cannot instantiate Groovy script to apply forbiddenapis plugin.", (Throwable)e);
        }
        script.setDelegate((Object)this);
        script.setProperty("project", (Object)project);
        script.run();
    }
}

