/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.hashbelt.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.castor.cache.hashbelt.container.Container;
import org.castor.util.concurrent.ConcurrentHashMap;

public final class FastIteratingContainer
implements Container {
    private Map _container = new ConcurrentHashMap();
    private ArrayList _keys = new ArrayList();
    private ArrayList _values = new ArrayList();
    private long _timestamp = 0L;

    public void updateTimestamp() {
        this._timestamp = System.currentTimeMillis();
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public synchronized Iterator keyIterator() {
        return ((ArrayList)this._keys.clone()).iterator();
    }

    public synchronized Iterator valueIterator() {
        return ((ArrayList)this._values.clone()).iterator();
    }

    public int size() {
        return this._container.size();
    }

    public boolean isEmpty() {
        return this._container.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this._container.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this._container.containsValue(value);
    }

    public Object get(Object key) {
        return this._container.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Object oldValue = this._container.put(key, value);
        if (oldValue == null) {
            FastIteratingContainer fastIteratingContainer = this;
            synchronized (fastIteratingContainer) {
                this._keys.add(key);
                this._values.add(value);
            }
        }
        if (oldValue != value) {
            FastIteratingContainer fastIteratingContainer = this;
            synchronized (fastIteratingContainer) {
                this._values.remove(oldValue);
                this._values.add(value);
            }
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Object oldValue = this._container.remove(key);
        if (oldValue != null) {
            FastIteratingContainer fastIteratingContainer = this;
            synchronized (fastIteratingContainer) {
                this._keys.remove(key);
                this._values.remove(oldValue);
            }
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map map) {
        Iterator iter = map.entrySet().iterator();
        FastIteratingContainer fastIteratingContainer = this;
        synchronized (fastIteratingContainer) {
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this._container.clear();
        FastIteratingContainer fastIteratingContainer = this;
        synchronized (fastIteratingContainer) {
            this._keys.clear();
            this._values.clear();
        }
    }

    public Set keySet() {
        return this._container.keySet();
    }

    public Collection values() {
        return this._container.values();
    }

    public Set entrySet() {
        return this._container.entrySet();
    }
}

