/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.opensaml.MalformedException;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class SAMLObject
implements Cloneable {
    protected SAMLConfig config = SAMLConfig.instance();
    protected Node root = null;
    protected Logger log = Logger.getLogger(this.getClass());
    protected SAMLObject parentObject = null;
    protected boolean dirty = true;

    protected void setDirty(boolean bl) {
        this.dirty = bl;
        if (bl && this.parentObject != null) {
            this.parentObject.setDirty(bl);
        }
    }

    protected static Element fromStream(InputStream inputStream) throws SAMLException {
        try {
            Document document = XML.parserPool.parse(inputStream);
            return document.getDocumentElement();
        }
        catch (Exception exception) {
            NDC.push((String)"fromStream");
            Logger.getLogger((String)SAMLObject.class.getName()).error((Object)("caught an exception while parsing a stream:\n" + exception.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLObject.fromStream() caught exception while parsing a stream", exception);
        }
    }

    protected static Element fromStream(InputStream inputStream, int n) throws SAMLException {
        try {
            Document document = XML.parserPool.parse(new InputSource(inputStream), n == 1 ? XML.parserPool.getSchemaSAML11() : XML.parserPool.getSchemaSAML10());
            return document.getDocumentElement();
        }
        catch (Exception exception) {
            NDC.push((String)"fromStream");
            Logger.getLogger((String)SAMLObject.class.getName()).error((Object)("caught an exception while parsing a stream:\n" + exception.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLObject.fromStream() caught exception while parsing a stream", exception);
        }
    }

    protected Node plantRoot() {
        if (this.root != null) {
            Node node = this.root;
            while (node.getParentNode() != null && node.getParentNode().getNodeType() != 9) {
                node = node.getParentNode();
            }
            Element element = this.root.getOwnerDocument().getDocumentElement();
            if (element != null && element != node) {
                this.root.getOwnerDocument().replaceChild(node, element);
            } else if (element == null) {
                this.root.getOwnerDocument().appendChild(node);
            }
        }
        return this.root;
    }

    protected abstract Element buildRoot(Document var1, boolean var2);

    public abstract void checkValidity() throws SAMLException;

    public SAMLObject setParent(SAMLObject sAMLObject) throws SAMLException {
        if (this.parentObject != null) {
            throw new SAMLException("SAMLObject.setParent() called on an already-contained object");
        }
        if (sAMLObject == null) {
            throw new IllegalArgumentException("SAMLObject.setParent() called with null parameter");
        }
        this.parentObject = sAMLObject;
        return this;
    }

    public SAMLObject getParent() {
        return this.parentObject;
    }

    public void fromDOM(Element element) throws SAMLException {
        if (element == null) {
            throw new MalformedException("SAMLObject.fromDOM() given an empty DOM");
        }
        this.root = element;
        this.setDirty(false);
    }

    public void toStream(OutputStream outputStream) throws IOException, SAMLException {
        try {
            this.toDOM();
            this.plantRoot();
            Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/2001/10/xml-exc-c14n#");
            outputStream.write(canonicalizer.canonicalizeSubtree(this.root, this.config.getProperty("org.opensaml.inclusive-namespace-prefixes")));
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new IOException(invalidCanonicalizerException.getMessage());
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new IOException(canonicalizationException.getMessage());
        }
    }

    public byte[] toBase64() throws IOException, SAMLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.toStream(byteArrayOutputStream);
        return Base64.encodeBase64Chunked((byte[])byteArrayOutputStream.toByteArray());
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        this.checkValidity();
        if (this.root != null) {
            if (!this.dirty) {
                if (this.root.getOwnerDocument() != document) {
                    this.root = document.adoptNode(this.root);
                    return this.root;
                }
                return this.root;
            }
            this.log.debug((Object)"toDOM() detected object changes, rebuilding tree");
        }
        this.root = this.buildRoot(document, bl);
        return this.root;
    }

    public Node toDOM(boolean bl) throws SAMLException {
        if (this.root != null) {
            return this.toDOM(this.root.getOwnerDocument(), bl);
        }
        return this.toDOM(XML.parserPool.newDocument(), bl);
    }

    public Node toDOM(Document document) throws SAMLException {
        return this.toDOM(document, true);
    }

    public Node toDOM() throws SAMLException {
        return this.toDOM(true);
    }

    protected Object clone() throws CloneNotSupportedException {
        SAMLObject sAMLObject = (SAMLObject)super.clone();
        sAMLObject.root = null;
        sAMLObject.parentObject = null;
        sAMLObject.dirty = true;
        return sAMLObject;
    }

    public String toString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.toStream(byteArrayOutputStream);
            return byteArrayOutputStream.toString("UTF8");
        }
        catch (IOException iOException) {
            NDC.push((String)"toString");
            this.log.error((Object)("caught an I/O exception while serializing XML: " + iOException));
            NDC.pop();
            return "";
        }
        catch (SAMLException sAMLException) {
            NDC.push((String)"toString");
            this.log.error((Object)("caught a SAML exception while serializing XML: " + sAMLException));
            NDC.pop();
            return "";
        }
    }
}

