/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import ucar.nc2.NetcdfFile;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.remote.PointDatasetRemote;
import ucar.nc2.ft.point.writer.FeatureDatasetPointXML;
import ucar.nc2.stream.CdmRemote;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;

public class CdmrFeatureDataset {
    public static final String SCHEME = "cdmrFeature:";
    private static boolean debug = false;
    private static boolean showXML = false;

    public static FeatureDataset factory(FeatureType wantFeatureType, String endpoint) throws IOException {
        FeatureType ft;
        if (endpoint.startsWith(SCHEME)) {
            endpoint = endpoint.substring(SCHEME.length());
        }
        Document doc = CdmrFeatureDataset.getCapabilities(endpoint);
        Element root = doc.getRootElement();
        Element elem = root.getChild("featureDataset");
        String fType = elem.getAttribute("type").getValue();
        String uri = elem.getAttribute("url").getValue();
        if (debug) {
            System.out.printf("CdmrFeatureDataset endpoint %s%n ftype= %s url=%s%n", endpoint, fType, uri);
        }
        if ((ft = FeatureType.getType(fType)) == null || ft == FeatureType.NONE || ft == FeatureType.GRID) {
            CdmRemote ncremote = new CdmRemote(uri);
            NetcdfDataset ncd = new NetcdfDataset((NetcdfFile)ncremote, null);
            return new GridDataset(ncd);
        }
        List<VariableSimpleIF> dataVars = FeatureDatasetPointXML.getDataVariables(doc);
        LatLonRect bb = FeatureDatasetPointXML.getSpatialExtent(doc);
        CalendarDateRange dr = FeatureDatasetPointXML.getTimeSpan(doc);
        DateUnit timeUnit = FeatureDatasetPointXML.getTimeUnit(doc);
        String altUnits = FeatureDatasetPointXML.getAltUnits(doc);
        return new PointDatasetRemote(ft, uri, timeUnit, altUnits, dataVars, bb, dr);
    }

    private static Document getCapabilities(String endpoint) throws IOException {
        Document doc;
        InputStream in = null;
        try {
            in = CdmRemote.sendQuery(endpoint, "req=capabilities");
            SAXBuilder builder = new SAXBuilder(false);
            doc = builder.build(in);
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        if (showXML) {
            System.out.printf("*** endpoint = %s %n", endpoint);
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.printf("*** CdmrFeatureDataset/showParsedXML = %n %s %n", xmlOut.outputString(doc));
        }
        return doc;
    }

    public static void main(String[] args) throws IOException {
        String endpoint = "http://localhost:8080/thredds/cdmrfeature/idd/metar/ncdecodedLocalHome";
        FeatureDatasetPoint fd = (FeatureDatasetPoint)CdmrFeatureDataset.factory(FeatureType.ANY, endpoint);
        FeatureCollection fc = fd.getPointFeatureCollectionList().get(0);
        System.out.printf("Result= %s %n %s %n", fd, fc);
    }
}

