/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs;

import java.io.IOException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.jboss.resteasy.client.jaxrs.engines.PassthroughTrustManager;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ResteasyClientBuilder
extends ClientBuilder {
    protected KeyStore truststore;
    protected KeyStore clientKeyStore;
    protected String clientPrivateKeyPassword;
    protected boolean disableTrustManager;
    protected HostnameVerificationPolicy policy = HostnameVerificationPolicy.WILDCARD;
    protected ResteasyProviderFactory providerFactory;
    protected ExecutorService asyncExecutor;
    protected boolean cleanupExecutor;
    protected SSLContext sslContext;
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected ClientHttpEngine httpEngine;
    protected int connectionPoolSize;
    protected int maxPooledPerRoute = 0;
    protected long connectionTTL = -1L;
    protected TimeUnit connectionTTLUnit = TimeUnit.MILLISECONDS;
    protected long socketTimeout = -1L;
    protected TimeUnit socketTimeoutUnits = TimeUnit.MILLISECONDS;
    protected long establishConnectionTimeout = -1L;
    protected TimeUnit establishConnectionTimeoutUnits = TimeUnit.MILLISECONDS;
    protected int connectionCheckoutTimeoutMs = -1;
    protected HostnameVerifier verifier = null;
    protected HttpHost defaultProxy;
    protected int responseBufferSize;

    public ResteasyClientBuilder providerFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
        return this;
    }

    public ResteasyClientBuilder asyncExecutor(ExecutorService asyncExecutor) {
        return this.asyncExecutor(asyncExecutor, false);
    }

    public ResteasyClientBuilder asyncExecutor(ExecutorService asyncExecutor, boolean cleanupExecutor) {
        this.asyncExecutor = asyncExecutor;
        this.cleanupExecutor = cleanupExecutor;
        return this;
    }

    public ResteasyClientBuilder connectionTTL(long ttl, TimeUnit unit) {
        this.connectionTTL = ttl;
        this.connectionTTLUnit = unit;
        return this;
    }

    public ResteasyClientBuilder socketTimeout(long timeout, TimeUnit unit) {
        this.socketTimeout = timeout;
        this.socketTimeoutUnits = unit;
        return this;
    }

    public ResteasyClientBuilder establishConnectionTimeout(long timeout, TimeUnit unit) {
        this.establishConnectionTimeout = timeout;
        this.establishConnectionTimeoutUnits = unit;
        return this;
    }

    public ResteasyClientBuilder maxPooledPerRoute(int maxPooledPerRoute) {
        this.maxPooledPerRoute = maxPooledPerRoute;
        return this;
    }

    public ResteasyClientBuilder connectionCheckoutTimeout(long timeout, TimeUnit unit) {
        this.connectionCheckoutTimeoutMs = (int)TimeUnit.MILLISECONDS.convert(timeout, unit);
        return this;
    }

    public ResteasyClientBuilder connectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
        return this;
    }

    public ResteasyClientBuilder responseBufferSize(int size) {
        this.responseBufferSize = size;
        return this;
    }

    public ResteasyClientBuilder disableTrustManager() {
        this.disableTrustManager = true;
        return this;
    }

    public ResteasyClientBuilder hostnameVerification(HostnameVerificationPolicy policy) {
        this.policy = policy;
        return this;
    }

    public ResteasyClientBuilder httpEngine(ClientHttpEngine httpEngine) {
        this.httpEngine = httpEngine;
        return this;
    }

    public ResteasyClientBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public ResteasyClientBuilder trustStore(KeyStore truststore) {
        this.truststore = truststore;
        return this;
    }

    public ResteasyClientBuilder keyStore(KeyStore keyStore, String password) {
        this.clientKeyStore = keyStore;
        this.clientPrivateKeyPassword = password;
        return this;
    }

    public ResteasyClientBuilder keyStore(KeyStore keyStore, char[] password) {
        this.clientKeyStore = keyStore;
        this.clientPrivateKeyPassword = new String(password);
        return this;
    }

    public ResteasyClientBuilder property(String name, Object value) {
        this.getProviderFactory().property(name, value);
        return this;
    }

    public ResteasyClientBuilder defaultProxy(String hostname) {
        return this.defaultProxy(hostname, -1, null);
    }

    public ResteasyClientBuilder defaultProxy(String hostname, int port) {
        return this.defaultProxy(hostname, port, null);
    }

    public ResteasyClientBuilder defaultProxy(String hostname, int port, String scheme) {
        this.defaultProxy = new HttpHost(hostname, port, scheme);
        return this;
    }

    protected ResteasyProviderFactory getProviderFactory() {
        if (this.providerFactory == null) {
            this.providerFactory = new ResteasyProviderFactory();
            RegisterBuiltin.register((ResteasyProviderFactory)this.providerFactory);
        }
        return this.providerFactory;
    }

    public ResteasyClient build() {
        ClientHttpEngine engine;
        ClientConfiguration config = new ClientConfiguration(this.getProviderFactory());
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            config.property(entry.getKey(), entry.getValue());
        }
        ExecutorService executor = this.asyncExecutor;
        if (executor == null) {
            this.cleanupExecutor = true;
            executor = Executors.newFixedThreadPool(10);
        }
        if ((engine = this.httpEngine) == null) {
            engine = this.initDefaultEngine();
        }
        return new ResteasyClient(engine, executor, this.cleanupExecutor, config);
    }

    protected ClientHttpEngine initDefaultEngine() {
        DefaultHttpClient httpClient = null;
        VerifierWrapper verifier = null;
        if (this.verifier != null) {
            verifier = new VerifierWrapper(this.verifier);
        } else {
            switch (this.policy) {
                case ANY: {
                    verifier = new AllowAllHostnameVerifier();
                    break;
                }
                case WILDCARD: {
                    verifier = new BrowserCompatHostnameVerifier();
                    break;
                }
                case STRICT: {
                    verifier = new StrictHostnameVerifier();
                }
            }
        }
        try {
            SSLSocketFactory sslsf = null;
            SSLContext theContext = this.sslContext;
            if (this.disableTrustManager) {
                theContext = SSLContext.getInstance("SSL");
                theContext.init(null, new TrustManager[]{new PassthroughTrustManager()}, new SecureRandom());
                verifier = new AllowAllHostnameVerifier();
                sslsf = new SSLSocketFactory(theContext, (X509HostnameVerifier)verifier);
            } else if (theContext != null) {
                sslsf = new SSLSocketFactory(theContext, (X509HostnameVerifier)verifier);
            } else if (this.clientKeyStore != null || this.truststore != null) {
                sslsf = new SSLSocketFactory("TLS", this.clientKeyStore, this.clientPrivateKeyPassword, this.truststore, null, (X509HostnameVerifier)verifier);
            } else {
                SSLContext tlsContext = SSLContext.getInstance("TLS");
                tlsContext.init(null, null, null);
                sslsf = new SSLSocketFactory(tlsContext, (X509HostnameVerifier)verifier);
            }
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
            Scheme httpsScheme = new Scheme("https", 443, (SchemeSocketFactory)sslsf);
            registry.register(httpsScheme);
            BasicClientConnectionManager cm = null;
            if (this.connectionPoolSize > 0) {
                PoolingClientConnectionManager tcm = new PoolingClientConnectionManager(registry, this.connectionTTL, this.connectionTTLUnit);
                tcm.setMaxTotal(this.connectionPoolSize);
                if (this.maxPooledPerRoute == 0) {
                    this.maxPooledPerRoute = this.connectionPoolSize;
                }
                tcm.setDefaultMaxPerRoute(this.maxPooledPerRoute);
                cm = tcm;
            } else {
                cm = new BasicClientConnectionManager(registry);
            }
            BasicHttpParams params = new BasicHttpParams();
            if (this.socketTimeout > -1L) {
                HttpConnectionParams.setSoTimeout((HttpParams)params, (int)((int)this.socketTimeoutUnits.toMillis(this.socketTimeout)));
            }
            if (this.establishConnectionTimeout > -1L) {
                HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)((int)this.establishConnectionTimeoutUnits.toMillis(this.establishConnectionTimeout)));
            }
            if (this.connectionCheckoutTimeoutMs > -1) {
                HttpClientParams.setConnectionManagerTimeout((HttpParams)params, (long)this.connectionCheckoutTimeoutMs);
            }
            httpClient = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)params);
            ApacheHttpClient4Engine engine = new ApacheHttpClient4Engine((HttpClient)httpClient, true);
            engine.setResponseBufferSize(this.responseBufferSize);
            engine.setHostnameVerifier((HostnameVerifier)((Object)verifier));
            engine.setSslContext(theContext);
            engine.setDefaultProxy(this.defaultProxy);
            return engine;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ResteasyClientBuilder hostnameVerifier(HostnameVerifier verifier) {
        this.verifier = verifier;
        return this;
    }

    public Configuration getConfiguration() {
        return this.getProviderFactory().getConfiguration();
    }

    public ResteasyClientBuilder register(Class<?> componentClass) {
        this.getProviderFactory().register(componentClass);
        return this;
    }

    public ResteasyClientBuilder register(Class<?> componentClass, int priority) {
        this.getProviderFactory().register(componentClass, priority);
        return this;
    }

    public ResteasyClientBuilder register(Class<?> componentClass, Class<?> ... contracts) {
        this.getProviderFactory().register(componentClass, (Class[])contracts);
        return this;
    }

    public ResteasyClientBuilder register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.getProviderFactory().register(componentClass, contracts);
        return this;
    }

    public ResteasyClientBuilder register(Object component) {
        this.getProviderFactory().register(component);
        return this;
    }

    public ResteasyClientBuilder register(Object component, int priority) {
        this.getProviderFactory().register(component, priority);
        return this;
    }

    public ResteasyClientBuilder register(Object component, Class<?> ... contracts) {
        this.getProviderFactory().register(component, (Class[])contracts);
        return this;
    }

    public ResteasyClientBuilder register(Object component, Map<Class<?>, Integer> contracts) {
        this.getProviderFactory().register(component, contracts);
        return this;
    }

    public ResteasyClientBuilder withConfig(Configuration config) {
        Map contracts;
        this.providerFactory = new ResteasyProviderFactory();
        this.providerFactory.setProperties(config.getProperties());
        for (Class clazz : config.getClasses()) {
            contracts = config.getContracts(clazz);
            try {
                this.register(clazz, contracts);
            }
            catch (RuntimeException e) {
                throw new RuntimeException(Messages.MESSAGES.failedOnRegisteringClass(clazz.getName()), e);
            }
        }
        for (Object obj : config.getInstances()) {
            contracts = config.getContracts(obj.getClass());
            this.register(obj, contracts);
        }
        return this;
    }

    static class VerifierWrapper
    implements X509HostnameVerifier {
        protected HostnameVerifier verifier;

        VerifierWrapper(HostnameVerifier verifier) {
            this.verifier = verifier;
        }

        public void verify(String host, SSLSocket ssl) throws IOException {
            if (!this.verifier.verify(host, ssl.getSession())) {
                throw new SSLException(Messages.MESSAGES.hostnameVerificationFailure());
            }
        }

        public void verify(String host, X509Certificate cert) throws SSLException {
            throw new SSLException(Messages.MESSAGES.verificationPathNotImplemented());
        }

        public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            throw new SSLException(Messages.MESSAGES.verificationPathNotImplemented());
        }

        public boolean verify(String s, SSLSession sslSession) {
            return this.verifier.verify(s, sslSession);
        }
    }

    public static enum HostnameVerificationPolicy {
        ANY,
        WILDCARD,
        STRICT;

    }
}

