/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CommonArrayFSImpl;

public class ArrayFSImpl
extends CommonArrayFSImpl
implements ArrayFS {
    public ArrayFSImpl(int addr, CASImpl cas) {
        super(cas, addr);
    }

    @Override
    public int size() {
        return this.getCASImpl().ll_getArraySize(this.getAddress());
    }

    @Override
    public FeatureStructure get(int i) {
        if (i < 0 || i >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.casImpl.createFS(this.casImpl.getArrayValue(this.addr, i));
    }

    @Override
    public void set(int i, FeatureStructure fs) throws ArrayIndexOutOfBoundsException {
        this.casImpl.setArrayValue(this.addr, i, this.getCASImpl().ll_getFSRef(fs));
    }

    @Override
    public void copyFromArray(FeatureStructure[] src, int srcOffset, int destOffset, int length) throws ArrayIndexOutOfBoundsException {
        if (destOffset < 0 || destOffset + length > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        destOffset += this.casImpl.getArrayStartAddress(this.addr);
        for (int i = 0; i < length; ++i) {
            this.casImpl.getHeap().heap[destOffset] = this.getCASImpl().ll_getFSRef(src[srcOffset]);
            ++destOffset;
            ++srcOffset;
        }
    }

    @Override
    public void copyToArray(int srcOffset, FeatureStructure[] dest, int destOffset, int length) throws ArrayIndexOutOfBoundsException {
        if (srcOffset < 0 || srcOffset + length > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        srcOffset += this.casImpl.getArrayStartAddress(this.addr);
        for (int i = 0; i < length; ++i) {
            Object fs = null;
            int address = this.casImpl.getHeap().heap[srcOffset];
            if (address != 0) {
                fs = this.casImpl.createFS(address);
            }
            dest[destOffset] = fs;
            ++destOffset;
            ++srcOffset;
        }
    }

    @Override
    public FeatureStructure[] toArray() {
        int size = this.size();
        FeatureStructure[] outArray = new FeatureStructure[size];
        this.copyToArray(0, outArray, 0, size);
        return outArray;
    }

    @Override
    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        CASImpl ll = this.casImpl;
        ll.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            int address = ll.ll_getRefArrayValue(this.addr, i + srcOffset);
            String value = null;
            if (address != 0) {
                value = ll.ll_getFSForRef(address).toString();
            }
            dest[i + destOffset] = value;
        }
    }

    @Override
    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) {
        throw new UnsupportedOperationException();
    }
}

