/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StoreManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(StoreManagerFactory.class);

    private StoreManagerFactory() {
    }

    public static StoreManager createInstance(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            String msg = "Failed to create StoredObjectCreator, class " + className + " does not exist.";
            LOG.error(msg, (Throwable)e);
            throw new CmisRuntimeException(msg, (Throwable)e);
        }
        Object obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (InstantiationException e) {
            LOG.error("Failed to create StoredObjectCreator from class " + className, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Failed to create StoredObjectCreator from class " + className, (Throwable)e);
        }
        if (obj instanceof StoreManager) {
            return obj;
        }
        LOG.error("Failed to create StoredObjectCreator, class " + className + " does not implement interface StoredObjectCreator");
        return null;
    }
}

