/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.exolab.castor.types.OperationNotSupportedException;
import org.exolab.castor.types.TimePeriod;

public class Month
extends TimePeriod {
    private static final long serialVersionUID = 8102039626686892932L;
    private static final boolean DEBUG = false;
    private static final String MONTH_FORMAT = "yyyy-MM";

    public Month() {
        super("P1M");
        int temp = TimeZone.getDefault().getRawOffset();
        if (temp < 0) {
            temp = -temp;
            try {
                super.setZoneNegative();
            }
            catch (OperationNotSupportedException e) {
                // empty catch block
            }
        }
        short zhour = (short)(temp / 3600000);
        short zmin = (short)((temp %= 3600000) / 60000);
        try {
            super.setZone(zhour, zmin);
        }
        catch (OperationNotSupportedException e) {
            // empty catch block
        }
    }

    public void setDay(short day) throws OperationNotSupportedException {
        String err = "In a Month : the day field must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public void setHour(short hour) throws OperationNotSupportedException {
        String err = "In a Month : the hour field must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public void setMinute(short minute) throws OperationNotSupportedException {
        String err = "In a Month : the minute field must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public void setSecond(short second, short millsecond) throws OperationNotSupportedException {
        String err = "In a Month : the second fields must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public void setZone(short hour, short minute) throws OperationNotSupportedException {
        String err = "In a Month : the time zone fields must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public void setZoneNegative() throws OperationNotSupportedException {
        String err = "In a Month : the tinme zone fields must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getCentury());
        if (result.length() == 1) {
            result.insert(0, 0);
        }
        if (this.getYear() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getYear());
        result.append('-');
        if (this.getMonth() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getMonth());
        if (this.isNegative()) {
            result.insert(0, '-');
        }
        return result.toString();
    }

    public static Object parse(String str) throws ParseException {
        return Month.parseMonth(str);
    }

    public static Month parseMonth(String str) throws ParseException {
        StringTokenizer token;
        Month result = new Month();
        if (str.startsWith("-")) {
            result.setNegative();
        }
        if ((token = new StringTokenizer(str, "-")).countTokens() != 2) {
            throw new ParseException(str + ": Bad XML Schema Month type format (CCYY-MM)", 0);
        }
        String temp = token.nextToken();
        if (temp.length() != 4) {
            throw new ParseException(str + ": Bad year format", 1);
        }
        result.setCentury(Short.parseShort(temp.substring(0, 2)));
        try {
            result.setYear(Short.parseShort(temp.substring(2, 4)));
        }
        catch (OperationNotSupportedException e) {
            // empty catch block
        }
        temp = token.nextToken();
        if (temp.length() != 2) {
            throw new ParseException(str + ": Bad month format", 5);
        }
        try {
            result.setMonth(Short.parseShort(temp));
        }
        catch (OperationNotSupportedException e) {
            // empty catch block
        }
        temp = null;
        return result;
    }

    public Date toDate() throws ParseException {
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat(MONTH_FORMAT);
        SimpleTimeZone timeZone = new SimpleTimeZone(0, "UTC");
        if (!this.isUTC()) {
            int offset = 0;
            offset = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            offset = this.isZoneNegative() ? -offset : offset;
            timeZone.setRawOffset(offset);
            timeZone.setID(TimeZone.getAvailableIDs(offset)[0]);
        }
        df.setTimeZone(timeZone);
        date = df.parse(this.toString());
        return date;
    }
}

