/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkMaintenanceUtils;
import org.apache.zookeeper.KeeperException;

class ZkCopier
implements ZkMaintenanceUtils.ZkVisitor {
    String source;
    String dest;
    SolrZkClient zkClient;

    ZkCopier(SolrZkClient zkClient, String source, String dest) {
        this.source = source;
        this.dest = dest;
        if (dest.endsWith("/")) {
            this.dest = dest.substring(0, dest.length() - 1);
        }
        this.zkClient = zkClient;
    }

    @Override
    public void visit(String path) throws InterruptedException, KeeperException {
        Object finalDestination = this.dest;
        if (!path.equals(this.source)) {
            finalDestination = (String)finalDestination + "/" + path.substring(this.source.length() + 1);
        }
        this.zkClient.makePath((String)finalDestination, false, true);
        this.zkClient.setData((String)finalDestination, this.zkClient.getData(path, null, null, true), true);
    }
}

