/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.IterableUtil;

public class ShouldHaveExactlyTypes
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldHaveTypes(Object actual, Iterable<Class<?>> expectedTypes, Iterable<Class<?>> expectedTypesNotFoundInActual, Iterable<Class<?>> actualTypesNotExpected) {
        if (!IterableUtil.isNullOrEmpty(actualTypesNotExpected) && !IterableUtil.isNullOrEmpty(expectedTypesNotFoundInActual)) {
            return new ShouldHaveExactlyTypes(actual, expectedTypes, expectedTypesNotFoundInActual, actualTypesNotExpected);
        }
        boolean expectedTypesNotFoundInActualOnly = IterableUtil.isNullOrEmpty(actualTypesNotExpected);
        Iterable<Class<?>> diff = expectedTypesNotFoundInActualOnly ? expectedTypesNotFoundInActual : actualTypesNotExpected;
        return new ShouldHaveExactlyTypes(actual, expectedTypes, diff, expectedTypesNotFoundInActualOnly);
    }

    public static ErrorMessageFactory elementsTypesDifferAtIndex(Object actualElement, Class<?> expectedElement, int indexOfDifference) {
        return new ShouldHaveExactlyTypes(actualElement, expectedElement, indexOfDifference);
    }

    private ShouldHaveExactlyTypes(Object actual, Iterable<Class<?>> expected, Iterable<Class<?>> expectedTypesNotFoundInActual, Iterable<Class<?>> actualTypesNotExpected) {
        super("%nExpecting actual elements:%n  %s%nto have the following types (in this order):%n  %s%nbut there were no actual elements with these types:%n  %s%nand these actual elements types were not expected:%n  %s", actual, expected, expectedTypesNotFoundInActual, actualTypesNotExpected);
    }

    private ShouldHaveExactlyTypes(Object actual, Iterable<Class<?>> expected, Iterable<Class<?>> diff, boolean expectedTypesNotFoundInActualOnly) {
        super("%nExpecting actual elements:%n  %s%nto have the following types (in this order):%n  %s%n" + (expectedTypesNotFoundInActualOnly ? "but there were no actual elements with these types" : "but these actual elements types were not expected") + ":%n  %s", actual, expected, diff);
    }

    private ShouldHaveExactlyTypes(Object actualElement, Class<?> expectedType, int indexOfDifference) {
        super("%nactual element at index %s does not have the expected type, element was:%s%nactual element type: %s%nexpected type      : %s", indexOfDifference, actualElement, actualElement.getClass(), expectedType);
    }
}

