/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.time.Duration;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.helpers.PacketBuffer;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.output.OutputStreamWithChannel;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientHolder;
import org.apache.sshd.sftp.client.SftpMessage;
import org.apache.sshd.sftp.client.impl.AbstractSftpClient;
import org.apache.sshd.sftp.client.impl.SftpAckData;
import org.apache.sshd.sftp.client.impl.SftpResponse;
import org.apache.sshd.sftp.client.impl.SftpStatus;
import org.apache.sshd.sftp.common.SftpConstants;
import org.apache.sshd.sftp.common.SftpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpOutputStreamAsync
extends OutputStreamWithChannel
implements SftpClientHolder {
    protected final Logger log;
    protected final byte[] bb = new byte[1];
    protected final int bufferSize;
    protected Buffer buffer;
    protected SftpClient.CloseableHandle handle;
    protected long offset;
    protected final Deque<SftpAckData> pendingAcks = new LinkedList<SftpAckData>();
    private final AbstractSftpClient clientInstance;
    private final String path;
    private final byte[] handleId;
    private final boolean ownsHandle;
    private final Buffer[] bufferPool = new Buffer[2];
    private final int packetSize;
    private final int sftpPreamble;
    private final boolean usePacket;
    private int nextBuffer;
    private SftpMessage lastMsg;

    public SftpOutputStreamAsync(AbstractSftpClient client, int bufferSize, String path, Collection<SftpClient.OpenMode> mode) throws IOException {
        this(client, bufferSize, path, client.open(path, mode), true);
    }

    public SftpOutputStreamAsync(AbstractSftpClient client, int bufferSize, String path, SftpClient.CloseableHandle handle) {
        this(client, bufferSize, path, handle, true);
    }

    public SftpOutputStreamAsync(AbstractSftpClient client, int bufferSize, String path, SftpClient.CloseableHandle handle, boolean closeHandle) {
        this.log = LoggerFactory.getLogger(this.getClass());
        this.clientInstance = Objects.requireNonNull(client, "No SFTP client instance");
        this.path = path;
        this.handle = handle;
        this.handleId = this.handle.getIdentifier();
        this.sftpPreamble = 13 + this.handleId.length + 8 + 4;
        this.ownsHandle = closeHandle;
        this.packetSize = (int)client.getChannel().getRemoteWindow().getPacketSize();
        int bufSize = bufferSize;
        if (bufSize == 0) {
            bufSize = this.packetSize;
        } else {
            ValidateUtils.checkTrue((bufferSize >= 256 ? 1 : 0) != 0, (String)"SFTP write buffer too small: %d < %d", (Object[])new Object[]{bufferSize, 256});
            bufSize += this.sftpPreamble;
        }
        boolean bl = this.usePacket = bufSize <= this.packetSize;
        if (this.usePacket) {
            bufSize += 9;
        }
        this.bufferSize = bufSize;
    }

    @Override
    public final AbstractSftpClient getClient() {
        return this.clientInstance;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public final String getPath() {
        return this.path;
    }

    public boolean isOpen() {
        return this.handle != null && this.handle.isOpen();
    }

    public void write(int b) throws IOException {
        this.bb[0] = (byte)b;
        this.write(this.bb, 0, 1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(b, off, len);
        this.internalTransfer(in::read, false);
    }

    public long transferFrom(InputStream stream) throws IOException {
        return this.internalTransfer(stream::read, true);
    }

    public long transferFrom(ReadableByteChannel stream, long count) throws IOException {
        return this.internalTransfer(new ChannelReader(stream, count), false);
    }

    private Buffer getBuffer(Session session) {
        Object buf = this.bufferPool[this.nextBuffer];
        if (buf == null) {
            if (this.nextBuffer == 1 && this.lastMsg != null && this.lastMsg.getFuture().isDone()) {
                this.nextBuffer = 0;
                buf = this.bufferPool[0];
            } else {
                buf = this.usePacket ? session.createBuffer((byte)94, this.bufferSize) : new ByteArrayBuffer(this.bufferSize, false);
                this.bufferPool[this.nextBuffer] = buf;
            }
        }
        this.nextBuffer ^= 1;
        int hdr = buf instanceof PacketBuffer ? 14 + this.sftpPreamble : this.sftpPreamble;
        buf.rpos(hdr);
        buf.wpos(hdr);
        return buf;
    }

    private long internalTransfer(ByteInput stream, boolean forceFlush) throws IOException {
        AbstractSftpClient client = this.getClient();
        ClientSession session = client.getSession();
        boolean traceEnabled = this.log.isTraceEnabled();
        long writtenCount = 0L;
        boolean eof = false;
        do {
            int n;
            int pos;
            if (this.buffer == null) {
                this.buffer = this.getBuffer((Session)session);
            }
            int off = pos = this.buffer.wpos();
            for (int toRead = this.bufferSize - off; toRead > 0; toRead -= n) {
                n = stream.read(this.buffer.array(), off, toRead);
                if (n < 0) {
                    eof = true;
                    break;
                }
                off += n;
            }
            writtenCount += (long)(off - pos);
            this.buffer.wpos(off);
            if (off != this.bufferSize && (!eof || !forceFlush || this.buffer.available() <= 0)) continue;
            if (traceEnabled) {
                this.log.trace("write({}) flush after {} bytes", (Object)this, (Object)writtenCount);
            }
            this.internalFlush();
        } while (!eof);
        return writtenCount;
    }

    public void flush() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("flush(" + this.getPath() + ") stream is closed");
        }
        if (this.buffer != null && this.buffer.available() > 0) {
            this.internalFlush();
        }
        if (this.lastMsg != null) {
            this.lastMsg.waitUntilSent();
            this.lastMsg = null;
        }
    }

    private void internalFlush() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("flush(" + this.getPath() + ") stream is closed");
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        AbstractSftpClient client = this.getClient();
        int ackIndex = 1;
        while (true) {
            Buffer buf;
            SftpAckData ack;
            if ((ack = this.pendingAcks.peek()) == null) {
                if (!debugEnabled || ackIndex <= true) break;
                this.log.debug("flush({}) processed {} pending writes", (Object)this, (Object)(ackIndex - 1));
                break;
            }
            if (debugEnabled) {
                this.log.debug("flush({}) waiting for ack #{}: {}", new Object[]{this, ackIndex, ack});
            }
            if ((buf = client.receive(ack.id, Duration.ZERO)) == null) {
                if (!debugEnabled) break;
                this.log.debug("flush({}) no response for ack #{}: {}", new Object[]{this, ackIndex, ack});
                break;
            }
            if (debugEnabled) {
                this.log.debug("flush({}) processing ack #{}: {}", new Object[]{this, ackIndex, ack});
            }
            this.pendingAcks.removeFirst();
            this.checkStatus(client, buf);
            ++ackIndex;
        }
        Buffer currentData = this.buffer;
        this.buffer = null;
        if (currentData == null) {
            if (debugEnabled) {
                this.log.debug("flush({}) no pending buffer to flush", (Object)this);
            }
            return;
        }
        int avail = currentData.available();
        if (avail == 0) {
            if (debugEnabled) {
                this.log.debug("flush({}) no pending data in buffer to flush", (Object)this);
            }
            return;
        }
        long currentOffset = this.offset;
        this.offset += (long)avail;
        int wpos = currentData.wpos();
        currentData.rpos(currentData.rpos() - 16 - this.handleId.length);
        currentData.wpos(currentData.rpos());
        currentData.putBytes(this.handleId);
        currentData.putLong(currentOffset);
        currentData.putUInt((long)avail);
        currentData.wpos(wpos);
        if (this.lastMsg != null) {
            this.lastMsg.waitUntilSent();
        }
        this.lastMsg = client.write(6, currentData);
        SftpAckData ack = new SftpAckData(this.lastMsg.getId(), currentOffset, avail);
        if (debugEnabled) {
            this.log.debug("flush({}) enqueue pending ack={}", (Object)this, (Object)ack);
        }
        this.pendingAcks.add(ack);
    }

    private void checkStatus(AbstractSftpClient client, Buffer buf) throws IOException {
        if (buf.available() >= 13) {
            int rpos = buf.rpos();
            buf.rpos(rpos + 4);
            int cmd = buf.getUByte();
            if (cmd != 101) {
                throw new SftpException(5, "Unexpected SFTP response; expected SSH_FXP_STATUS but got " + SftpConstants.getCommandMessageName(cmd));
            }
            buf.rpos(rpos + 9);
            if (buf.getInt() == 0) {
                return;
            }
            buf.rpos(rpos);
        }
        SftpResponse response = SftpResponse.parse(6, buf);
        client.checkResponseStatus(6, response.getId(), SftpStatus.parse(response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        try {
            boolean debugEnabled = this.log.isDebugEnabled();
            try {
                Duration idleTimeout;
                int pendingSize;
                int n = pendingSize = this.buffer == null ? 0 : this.buffer.available();
                if (pendingSize > 0) {
                    if (debugEnabled) {
                        this.log.debug("close({}) flushing {} pending bytes", (Object)this, (Object)pendingSize);
                    }
                    this.internalFlush();
                }
                if (this.lastMsg != null) {
                    this.lastMsg.waitUntilSent();
                    this.lastMsg = null;
                }
                if (GenericUtils.isNegativeOrNull((Duration)(idleTimeout = (Duration)CoreModuleProperties.IDLE_TIMEOUT.getRequired((PropertyResolver)this.getClient().getClientSession())))) {
                    idleTimeout = (Duration)CoreModuleProperties.IDLE_TIMEOUT.getRequiredDefault();
                }
                AbstractSftpClient client = this.getClient();
                int ackIndex = 1;
                while (!this.pendingAcks.isEmpty()) {
                    Buffer buf;
                    SftpAckData ack = this.pendingAcks.removeFirst();
                    if (debugEnabled) {
                        this.log.debug("close({}) processing ack #{}: {}", new Object[]{this, ackIndex, ack});
                    }
                    if ((buf = client.receive(ack.id, idleTimeout)) == null) {
                        this.log.debug("close({}) no ack response for {}", (Object)this, (Object)ack);
                        break;
                    }
                    if (debugEnabled) {
                        this.log.debug("close({}) processing ack #{} response for {}", new Object[]{this, ackIndex, ack});
                    }
                    this.checkStatus(client, buf);
                    ++ackIndex;
                }
            }
            finally {
                if (this.ownsHandle) {
                    if (debugEnabled) {
                        this.log.debug("close({}) closing file handle", (Object)this);
                    }
                    this.handle.close();
                }
            }
        }
        finally {
            this.handle = null;
            this.buffer = null;
            this.bufferPool[0] = null;
            this.bufferPool[1] = null;
            this.lastMsg = null;
        }
    }

    public String toString() {
        AbstractSftpClient client = this.getClient();
        return this.getClass().getSimpleName() + "[" + client.getSession() + "][" + this.getPath() + "]";
    }

    @FunctionalInterface
    private static interface ByteInput {
        public int read(byte[] var1, int var2, int var3) throws IOException;
    }

    private static class ChannelReader
    implements ByteInput {
        private final ReadableByteChannel src;
        private long stillToRead;

        ChannelReader(ReadableByteChannel src, long toRead) {
            this.src = src;
            this.stillToRead = toRead;
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            if (this.stillToRead <= 0L) {
                return -1;
            }
            ByteBuffer wrap = ByteBuffer.wrap(buffer, offset, (int)Math.min((long)length, this.stillToRead));
            int actuallyRead = this.src.read(wrap);
            if (actuallyRead < 0) {
                this.stillToRead = 0L;
                return -1;
            }
            this.stillToRead -= (long)actuallyRead;
            return actuallyRead;
        }
    }
}

