/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.io.IOException;
import java.net.ProtocolException;
import java.security.GeneralSecurityException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.future.DefaultKeyExchangeFuture;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.session.helpers.PendingWriteFuture;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.slf4j.Logger;

public class KeyExchangeMessageHandler {
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(false);
    protected final ExecutorService flushRunner = Executors.newSingleThreadExecutor();
    protected final AbstractSession session;
    protected final Logger log;
    protected final Queue<PendingWriteFuture> pendingPackets = new ConcurrentLinkedQueue<PendingWriteFuture>();
    protected volatile boolean kexFlushed = true;
    protected volatile DefaultKeyExchangeFuture kexFlushedFuture;

    public KeyExchangeMessageHandler(AbstractSession session, Logger log) {
        this.session = Objects.requireNonNull(session);
        this.log = Objects.requireNonNull(log);
        this.kexFlushedFuture = new DefaultKeyExchangeFuture(session.toString(), session.getFutureLock());
        this.kexFlushedFuture.setValue(Boolean.TRUE);
    }

    public void updateState(Runnable update) {
        this.updateState(() -> {
            update.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V updateState(Supplier<V> update) {
        boolean locked = false;
        if (this.lock.getReadHoldCount() == 0) {
            this.lock.writeLock().lock();
            locked = true;
        }
        try {
            V v = update.get();
            return v;
        }
        finally {
            if (locked) {
                this.lock.writeLock().unlock();
            }
        }
    }

    public DefaultKeyExchangeFuture initNewKeyExchange() {
        return this.updateState(() -> {
            this.kexFlushed = false;
            DefaultKeyExchangeFuture oldFuture = this.kexFlushedFuture;
            this.kexFlushedFuture = new DefaultKeyExchangeFuture(this.session.toString(), this.session.getFutureLock());
            return oldFuture;
        });
    }

    public AbstractMap.SimpleImmutableEntry<Integer, DefaultKeyExchangeFuture> terminateKeyExchange() {
        return this.updateState(() -> {
            int numPending = this.pendingPackets.size();
            if (numPending == 0) {
                this.kexFlushed = true;
            }
            return new AbstractMap.SimpleImmutableEntry<Integer, DefaultKeyExchangeFuture>(numPending, this.kexFlushedFuture);
        });
    }

    public void shutdown() {
        AbstractMap.SimpleImmutableEntry items = this.updateState(() -> {
            this.kexFlushed = true;
            return new AbstractMap.SimpleImmutableEntry<Integer, DefaultKeyExchangeFuture>(this.pendingPackets.size(), this.kexFlushedFuture);
        });
        ((DefaultKeyExchangeFuture)items.getValue()).setValue((Integer)items.getKey() == 0);
        this.flushRunner.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoWriteFuture writePacket(Buffer buffer, long timeout, TimeUnit unit) throws IOException {
        boolean enqueued;
        int cmd;
        block18: {
            IoWriteFuture ioWriteFuture;
            byte[] bufData = buffer.array();
            cmd = bufData[buffer.rpos()] & 0xFF;
            enqueued = false;
            boolean isLowLevelMessage = cmd <= 49 && cmd != 5 && cmd != 6;
            try {
                if (!isLowLevelMessage) break block18;
                ioWriteFuture = this.session.doWritePacket(buffer);
            }
            catch (Throwable throwable) {
                this.session.resetIdleTimeout();
                if (!enqueued) {
                    try {
                        this.session.checkRekey();
                    }
                    catch (GeneralSecurityException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("writePacket({}) failed ({}) to check re-key: {}", new Object[]{this.session, e.getClass().getSimpleName(), e.getMessage(), e});
                        }
                        throw ValidateUtils.initializeExceptionCause(new ProtocolException("Failed (" + e.getClass().getSimpleName() + ") to check re-key necessity: " + e.getMessage()), e);
                    }
                    catch (Exception e) {
                        ExceptionUtils.rethrowAsIoException(e);
                    }
                }
                throw throwable;
            }
            this.session.resetIdleTimeout();
            if (!enqueued) {
                try {
                    this.session.checkRekey();
                }
                catch (GeneralSecurityException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("writePacket({}) failed ({}) to check re-key: {}", new Object[]{this.session, e.getClass().getSimpleName(), e.getMessage(), e});
                    }
                    throw ValidateUtils.initializeExceptionCause(new ProtocolException("Failed (" + e.getClass().getSimpleName() + ") to check re-key necessity: " + e.getMessage()), e);
                }
                catch (Exception e) {
                    ExceptionUtils.rethrowAsIoException(e);
                }
            }
            return ioWriteFuture;
        }
        IoWriteFuture future = this.writeOrEnqueue(cmd, buffer, timeout, unit);
        enqueued = future instanceof PendingWriteFuture;
        IoWriteFuture ioWriteFuture = future;
        this.session.resetIdleTimeout();
        if (!enqueued) {
            try {
                this.session.checkRekey();
            }
            catch (GeneralSecurityException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("writePacket({}) failed ({}) to check re-key: {}", new Object[]{this.session, e.getClass().getSimpleName(), e.getMessage(), e});
                }
                throw ValidateUtils.initializeExceptionCause(new ProtocolException("Failed (" + e.getClass().getSimpleName() + ") to check re-key necessity: " + e.getMessage()), e);
            }
            catch (Exception e) {
                ExceptionUtils.rethrowAsIoException(e);
            }
        }
        return ioWriteFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IoWriteFuture writeOrEnqueue(int cmd, Buffer buffer, long timeout, TimeUnit unit) throws IOException {
        boolean holdsFutureLock = Thread.holdsLock(this.session.getFutureLock());
        while (true) {
            DefaultKeyExchangeFuture block;
            block12: {
                block = null;
                this.lock.readLock().lock();
                try {
                    boolean kexDone;
                    KexState state = this.session.kexState.get();
                    boolean bl = kexDone = KexState.DONE.equals((Object)state) || KexState.KEYS.equals((Object)state);
                    if (kexDone && this.kexFlushed) {
                        IoWriteFuture ioWriteFuture = this.session.doWritePacket(buffer);
                        return ioWriteFuture;
                    }
                    if (!holdsFutureLock && this.isBlockAllowed(cmd)) {
                        block = this.kexFlushedFuture;
                        break block12;
                    }
                    if (kexDone && this.log.isDebugEnabled()) {
                        this.log.debug("writeOrEnqueue({})[{}]: Queuing packet while flushing", (Object)this.session, (Object)SshConstants.getCommandMessageName(cmd));
                    }
                    PendingWriteFuture pendingWriteFuture = this.enqueuePendingPacket(cmd, buffer);
                    return pendingWriteFuture;
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
            if (block == null) continue;
            if (timeout <= 0L || unit == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("writeOrEnqueue({})[{}]: Blocking thread {} until KEX is over", new Object[]{this.session, SshConstants.getCommandMessageName(cmd), Thread.currentThread()});
                }
                block.await();
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("writeOrEnqueue({})[{}]: Blocking thread {} until KEX is over or timeout {} {}", new Object[]{this.session, SshConstants.getCommandMessageName(cmd), Thread.currentThread(), timeout, unit});
                }
                block.await(timeout, unit);
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("writeOrEnqueue({})[{}]: Thread {} awakens after KEX done", new Object[]{this.session, SshConstants.getCommandMessageName(cmd), Thread.currentThread()});
        }
    }

    protected boolean isBlockAllowed(int cmd) {
        boolean isChannelData = cmd == 94 || cmd == 95;
        return isChannelData && !ThreadUtils.isInternalThread();
    }

    protected PendingWriteFuture enqueuePendingPacket(int cmd, Buffer buffer) {
        String cmdName = SshConstants.getCommandMessageName(cmd);
        PendingWriteFuture future = new PendingWriteFuture((Object)cmdName, buffer);
        this.pendingPackets.add(future);
        int numPending = this.pendingPackets.size();
        if (this.log.isDebugEnabled()) {
            if (numPending == 1) {
                this.log.debug("enqueuePendingPacket({})[{}] Start flagging packets as pending until key exchange is done", (Object)this.session, (Object)cmdName);
            } else {
                this.log.debug("enqueuePendingPacket({})[{}] enqueued until key exchange is done (pending={})", new Object[]{this.session, cmdName, numPending});
            }
        }
        return future;
    }

    protected void flushQueue(DefaultKeyExchangeFuture flushDone) {
        this.flushRunner.submit(() -> {
            ArrayList<AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>> pendingFutures = new ArrayList<AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>>();
            boolean allFlushed = false;
            DefaultSshFuture newFuture = null;
            try {
                boolean warnedAboutChunkLimit = false;
                int lastSize = -1;
                int take = 2;
                while (!allFlushed) {
                    if (!this.session.isOpen()) {
                        this.log.info("flushQueue({}): Session closed while flushing pending packets at end of KEX", (Object)this.session);
                        flushDone.setValue(Boolean.FALSE);
                        return;
                    }
                    this.lock.writeLock().lock();
                    try {
                        if (this.pendingPackets.isEmpty()) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("flushQueue({}): All packets at end of KEX flushed", (Object)this.session);
                            }
                            this.kexFlushed = true;
                            allFlushed = true;
                        } else if (this.kexFlushedFuture != flushDone) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("flushQueue({}): Stopping flushing pending packets", (Object)this.session);
                            }
                            newFuture = this.kexFlushedFuture;
                        } else {
                            PendingWriteFuture pending;
                            int newSize = this.pendingPackets.size();
                            if (lastSize < 0) {
                                this.log.info("flushQueue({}): {} pending packets to flush", (Object)this.session, (Object)newSize);
                            } else if (newSize >= lastSize) {
                                this.log.info("flushQueue({}): queue size before={} now={}", new Object[]{this.session, lastSize, newSize});
                                if (take < 64) {
                                    take *= 2;
                                } else if (!warnedAboutChunkLimit) {
                                    warnedAboutChunkLimit = true;
                                    this.log.warn("flushQueue({}): maximum queue flush chunk of 64 reached", (Object)this.session);
                                }
                            }
                            lastSize = newSize;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("flushQueue({}): flushing {} packets", (Object)this.session, (Object)Math.min(lastSize, take));
                            }
                            for (int i = 0; i < take && (pending = this.pendingPackets.poll()) != null; ++i) {
                                try {
                                    if (this.log.isTraceEnabled()) {
                                        this.log.trace("flushQueue({}): Flushing a packet at end of KEX for {}", (Object)this.session, pending.getId());
                                    }
                                    IoWriteFuture written = this.session.doWritePacket(pending.getBuffer());
                                    pendingFutures.add(new AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>(pending, written));
                                    if (this.log.isTraceEnabled()) {
                                        this.log.trace("flushQueue({}): Flushed a packet at end of KEX for {}", (Object)this.session, pending.getId());
                                    }
                                    this.session.resetIdleTimeout();
                                    continue;
                                }
                                catch (Throwable e2) {
                                    this.log.error("flushQueue({}): Exception while flushing packet at end of KEX for {}", new Object[]{this.session, pending.getId(), e2});
                                    pending.setException(e2);
                                    flushDone.setValue(e2);
                                    this.session.exceptionCaught(e2);
                                    this.lock.writeLock().unlock();
                                    if (allFlushed) {
                                        flushDone.setValue(Boolean.TRUE);
                                    } else if (newFuture != null) {
                                        newFuture.addListener(f -> {
                                            Throwable error = f.getException();
                                            if (error != null) {
                                                flushDone.setValue(error);
                                            } else {
                                                flushDone.setValue(Boolean.TRUE);
                                            }
                                        });
                                    }
                                    pendingFutures.forEach(e -> ((IoWriteFuture)e.getValue()).addListener((SshFutureListener)e.getKey()));
                                    return;
                                }
                            }
                            if (!this.pendingPackets.isEmpty()) continue;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("flushQueue({}): All packets at end of KEX flushed", (Object)this.session);
                            }
                            this.kexFlushed = true;
                            allFlushed = true;
                        }
                        break;
                    }
                    finally {
                        this.lock.writeLock().unlock();
                    }
                }
            }
            finally {
                if (allFlushed) {
                    flushDone.setValue(Boolean.TRUE);
                } else if (newFuture != null) {
                    newFuture.addListener(f -> {
                        Throwable error = f.getException();
                        if (error != null) {
                            flushDone.setValue(error);
                        } else {
                            flushDone.setValue(Boolean.TRUE);
                        }
                    });
                }
                pendingFutures.forEach(e -> ((IoWriteFuture)e.getValue()).addListener((SshFutureListener)e.getKey()));
            }
        });
    }
}

