/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.core;

import java.nio.charset.Charset;
import java.time.Duration;
import org.apache.sshd.common.Property;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.auth.WelcomeBannerPhase;

public final class CoreModuleProperties {
    public static final Property<String> PROXY_AUTH_CHANNEL_TYPE = Property.string("ssh-agent-factory-proxy-auth-channel-type", "auth-agent-req@openssh.com");
    public static final Property<Boolean> PREFER_UNIX_AGENT = Property.bool("ssh-prefer-unix-agent", OsUtils.isUNIX());
    public static final Property<Duration> CHANNEL_OPEN_TIMEOUT = Property.duration("ssh-agent-server-channel-open-timeout", Duration.ofSeconds(30L));
    public static final Property<String> PROXY_CHANNEL_TYPE = Property.string("ssh-agent-server-channel-proxy-type", "auth-agent@openssh.com");
    public static final Property<Duration> AUTH_SOCKET_TIMEOUT = Property.duration("ssh-agent-server-proxy-auth-socket-timeout", Duration.ofHours(1L));
    public static final int DEFAULT_FORWARDER_BUF_SIZE = 1024;
    public static final int MIN_FORWARDER_BUF_SIZE = 127;
    public static final int MAX_FORWARDER_BUF_SIZE = Short.MAX_VALUE;
    public static final Property<Integer> FORWARDER_BUFFER_SIZE = Property.integer("channel-agent-fwd-buf-size", 1024);
    public static final Property<String> PREFERRED_AUTHS = Property.string("preferred-auths");
    public static final Property<Integer> PASSWORD_PROMPTS = Property.integer("password-prompts", 3);
    public static final Property<String> CLIENT_IDENTIFICATION = Property.string("client-identification");
    public static final Property<Boolean> SEND_IMMEDIATE_IDENTIFICATION = Property.bool("send-immediate-identification", true);
    public static final Property<Boolean> SEND_IMMEDIATE_KEXINIT = Property.bool("send-immediate-kex-init", true);
    public static final Property<Boolean> ALLOW_DHG1_KEX_FALLBACK = Property.bool("allow-dhg1-kex-fallback", false);
    public static final Property<Duration> KEX_PROPOSAL_SETUP_TIMEOUT = Property.durationSec("kex-proposal-setup-timeout", Duration.ofSeconds(42L), Duration.ofSeconds(5L));
    public static final Property<Duration> HEARTBEAT_INTERVAL = Property.duration("heartbeat-interval", Duration.ZERO);
    public static final Property<String> HEARTBEAT_REQUEST = Property.string("heartbeat-request", "keepalive@sshd.apache.org");
    public static final Property<Duration> HEARTBEAT_REPLY_WAIT = Property.durationSec("heartbeat-reply-wait", Duration.ofMinutes(5L));
    public static final Property<Boolean> IGNORE_INVALID_IDENTITIES = Property.bool("ignore-invalid-identities", true);
    public static final Property<Boolean> ABORT_ON_INVALID_CERTIFICATE = Property.bool("abort-on-invalid-certificate", false);
    public static final Property<String> INTERACTIVE_LANGUAGE_TAG = Property.string("kb-client-interactive-language-tag", "");
    public static final Property<String> INTERACTIVE_SUBMETHODS = Property.string("kb-client-interactive-sub-methods", "");
    public static final Property<Boolean> REQUEST_EXEC_REPLY = Property.bool("channel-exec-want-reply", false);
    public static final Property<Integer> INPUT_STREAM_PUMP_CHUNK_SIZE = Property.integer("stdin-pump-chunk-size", 1024);
    public static final Property<Boolean> REQUEST_SHELL_REPLY = Property.bool("channel-shell-want-reply", false);
    public static final Property<Boolean> REQUEST_SUBSYSTEM_REPLY = Property.bool("channel-subsystem-want-reply", true);
    public static final Property<Integer> PROP_DHGEX_CLIENT_MIN_KEY = Property.integer("dhgex-client-min");
    public static final Property<Integer> PROP_DHGEX_CLIENT_MAX_KEY = Property.integer("dhgex-client-max");
    public static final Property<Integer> PROP_DHGEX_CLIENT_PRF_KEY = Property.integer("dhgex-client-prf");
    public static final long DEFAULT_WINDOW_SIZE = 0x200000L;
    public static final Property<Long> WINDOW_SIZE = Property.long_("window-size", 0x200000L);
    public static final Property<Duration> WINDOW_TIMEOUT = Property.duration("window-timeout", Duration.ZERO);
    public static final Property<Integer> BUFFERED_IO_OUTPUT_MAX_PENDING_WRITE_SIZE = Property.integer("buffered-io-output-max-pending-write-size", 262144);
    public static final Property<Duration> BUFFERED_IO_OUTPUT_MAX_PENDING_WRITE_WAIT = Property.duration("buffered-io-output-max-pending-write-wait", Duration.ofSeconds(30L));
    public static final long DEFAULT_MAX_PACKET_SIZE = 32768L;
    public static final Property<Long> MAX_PACKET_SIZE = Property.long_("packet-size", 32768L);
    public static final long DEFAULT_LIMIT_PACKET_SIZE = 0x1FFFFFFFL;
    public static final Property<Long> LIMIT_PACKET_SIZE = Property.long_("max-packet-size", 0x1FFFFFFFL);
    public static final Property<Integer> NIO_WORKERS = Property.validating(Property.integer("nio-workers", Runtime.getRuntime().availableProcessors() + 1), w -> ValidateUtils.checkTrue(w > 0, "Number of NIO workers must be positive: %d", w));
    public static final Property<Duration> AUTH_TIMEOUT = Property.duration("auth-timeout", Duration.ofMinutes(2L));
    public static final Property<Duration> IDLE_TIMEOUT = Property.duration("idle-timeout", Duration.ofMinutes(10L));
    public static final Property<Duration> NIO2_READ_TIMEOUT = Property.duration("nio2-read-timeout", Duration.ZERO);
    public static final Property<Duration> NIO2_MIN_WRITE_TIMEOUT = Property.duration("nio2-min-write-timeout", Duration.ofSeconds(30L));
    public static final Property<Duration> DISCONNECT_TIMEOUT = Property.duration("disconnect-timeout", Duration.ofSeconds(10L));
    public static final Property<Duration> CHANNEL_CLOSE_TIMEOUT = Property.duration("channel-close-timeout", Duration.ofSeconds(5L));
    public static final Property<Duration> STOP_WAIT_TIME = Property.duration("stop-wait-time", Duration.ofMinutes(1L));
    public static final Property<Integer> SOCKET_BACKLOG = Property.integer("socket-backlog", 0);
    public static final Property<Boolean> SOCKET_KEEPALIVE = Property.bool("socket-keepalive", false);
    public static final Property<Integer> SOCKET_SNDBUF = Property.integer("socket-sndbuf");
    public static final Property<Integer> SOCKET_RCVBUF = Property.integer("socket-rcvbuf");
    public static final Property<Boolean> SOCKET_REUSEADDR = Property.bool("socket-reuseaddr", true);
    public static final Property<Integer> SOCKET_LINGER = Property.integer("socket-linger", -1);
    public static final Property<Boolean> TCP_NODELAY = Property.bool("tcp-nodelay", false);
    public static final Property<Integer> NIO2_READ_BUFFER_SIZE = Property.validating(Property.integer("nio2-read-buf-size", 32768), p -> {
        if (p != null) {
            ValidateUtils.checkTrue(p > 0, "Read buffer size must be > 0: %d", p);
        }
    });
    public static final Property<Integer> MIN_READ_BUFFER_SIZE = Property.validating(Property.integer("min-read-buf-size"), p -> {
        if (p != null) {
            ValidateUtils.checkTrue(p >= 64 && p <= 65536, "Minimum read buffer size must be in the range [64..65536]: %d", p);
        }
    });
    public static final Property<Integer> MAX_IDENTIFICATION_SIZE = Property.integer("max-identification-size", 16384);
    public static final Property<Long> REKEY_BYTES_LIMIT = Property.long_("rekey-bytes-limit", 0x40000000L);
    public static final Property<Duration> REKEY_TIME_LIMIT = Property.duration("rekey-time-limit", Duration.ofHours(1L));
    public static final Property<Long> REKEY_PACKETS_LIMIT = Property.long_("rekey-packets-limit", 0x80000000L);
    public static final Property<Long> REKEY_BLOCKS_LIMIT = Property.long_("rekey-blocks-limit", 0L);
    public static final Property<Long> IGNORE_MESSAGE_FREQUENCY = Property.long_("ignore-message-frequency", 1024L);
    public static final Property<Integer> IGNORE_MESSAGE_VARIANCE = Property.integer("ignore-message-variance", 32);
    public static final Property<Integer> IGNORE_MESSAGE_SIZE = Property.integer("ignore-message-size", 16);
    public static final String AGENT_FORWARDING_TYPE = "agent-fw-auth-type";
    public static final String AGENT_FORWARDING_TYPE_IETF = "auth-agent-req";
    public static final String AGENT_FORWARDING_TYPE_OPENSSH = "auth-agent-req@openssh.com";
    public static final Property<Duration> WAIT_FOR_SPACE_TIMEOUT = Property.duration("channel-output-wait-for-space-timeout", Duration.ofSeconds(30L));
    public static final Property<Duration> FORWARD_REQUEST_TIMEOUT = Property.duration("tcpip-forward-request-timeout", Duration.ofSeconds(15L));
    public static final Property<Integer> MAX_CONCURRENT_CHANNELS = Property.integer("max-sshd-channels", Integer.MAX_VALUE);
    public static final Property<Boolean> SEND_REPLY_FOR_CHANNEL_DATA = Property.bool("send-unknown-channel-data-reply", false);
    public static final Property<Integer> MAX_AUTH_REQUESTS = Property.integer("max-auth-requests", 20);
    public static final Property<Object> WELCOME_BANNER = Property.object("welcome-banner");
    public static final String AUTO_WELCOME_BANNER_VALUE = "#auto-welcome-banner";
    public static final Property<String> WELCOME_BANNER_LANGUAGE = Property.string("welcome-banner-language", "en");
    public static final Property<WelcomeBannerPhase> WELCOME_BANNER_PHASE = Property.enum_("welcome-banner-phase", WelcomeBannerPhase.class, WelcomeBannerPhase.IMMEDIATE);
    public static final Property<Charset> WELCOME_BANNER_CHARSET = Property.charset("welcome-banner-charset", Charset.defaultCharset());
    public static final Property<String> AUTH_METHODS = Property.string("auth-methods");
    public static final Property<Integer> MAX_CONCURRENT_SESSIONS = Property.integer("max-concurrent-sessions");
    public static final Property<String> SERVER_EXTRA_IDENTIFICATION_LINES = Property.string("server-extra-identification-lines");
    public static final char SERVER_EXTRA_IDENT_LINES_SEPARATOR = '|';
    public static final Property<String> SERVER_IDENTIFICATION = Property.string("server-identification");
    public static final Property<Duration> COMMAND_EXIT_TIMEOUT = Property.duration("command-exit-timeout", Duration.ofMillis(5L));
    public static final Property<String> MODULI_URL = Property.string("moduli-url");
    public static final Property<String> KB_SERVER_INTERACTIVE_NAME = Property.string("kb-server-interactive-name", "Password authentication");
    public static final Property<String> KB_SERVER_INTERACTIVE_INSTRUCTION = Property.string("kb-server-interactive-instruction", "");
    public static final Property<String> KB_SERVER_INTERACTIVE_LANG = Property.string("kb-server-interactive-language", "en-US");
    public static final Property<String> KB_SERVER_INTERACTIVE_PROMPT = Property.string("kb-server-interactive-prompt", "Password: ");
    public static final Property<Boolean> KB_SERVER_INTERACTIVE_ECHO_PROMPT = Property.bool("kb-server-interactive-echo-prompt", false);
    public static final Property<Integer> MAX_EXTDATA_BUFSIZE = Property.integer("channel-session-max-extdata-bufsize", 0);
    public static final Property<Integer> PROP_DHGEX_SERVER_MIN_KEY = Property.integer("dhgex-server-min");
    public static final Property<Integer> PROP_DHGEX_SERVER_MAX_KEY = Property.integer("dhgex-server-max");
    public static final Property<Duration> PUMP_SLEEP_TIME = Property.duration("inverted-shell-wrapper-pump-sleep", Duration.ofMillis(1L));
    public static final Property<Integer> BUFFER_SIZE = Property.integer("inverted-shell-wrapper-buffer-size", 8192);
    public static final Property<Duration> X11_OPEN_TIMEOUT = Property.duration("x11-fwd-open-timeout", Duration.ofSeconds(30L));
    public static final Property<Integer> X11_DISPLAY_OFFSET = Property.integer("x11-fwd-display-offset", 10);
    public static final Property<Integer> X11_MAX_DISPLAYS = Property.integer("x11-fwd-max-display", 1000);
    public static final Property<Integer> X11_BASE_PORT = Property.integer("x11-fwd-base-port", 6000);
    public static final Property<String> X11_BIND_HOST = Property.string("x11-fwd-bind-host", "127.0.0.1");

    private CoreModuleProperties() {
        throw new UnsupportedOperationException("No instance");
    }
}

