/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TagUtils {
    private static final Log LOG = LogFactory.getLog(TagUtils.class);

    private TagUtils() {
    }

    public static ValueBinding getValueBinding(String valueBindingExpression) {
        FacesContext context = FacesContext.getCurrentInstance();
        Application app = context.getApplication();
        return app.createValueBinding(valueBindingExpression);
    }

    public static void assertNotNull(Object object) {
        if (null == object) {
            throw new NullPointerException();
        }
    }

    public static String getString(String value) {
        return value;
    }

    public static boolean getBoolean(String value) {
        return Boolean.valueOf(value);
    }

    public static int getInteger(String value) {
        return Integer.valueOf(value);
    }

    public static long getLong(String value) {
        return Long.valueOf(value);
    }

    public static double getDouble(String value) {
        return Double.valueOf(value);
    }

    public static float getFloat(String value) {
        return Float.valueOf(value).floatValue();
    }

    public static Date getDate(String value) {
        return TagUtils.parseISODate(value);
    }

    public static Locale getLocale(String value) {
        return TagUtils.getLocaleInternal(value);
    }

    public static boolean isValueReference(String expression) {
        int start;
        return null != expression && (start = expression.indexOf("#{")) >= 0 && expression.indexOf(125, start + 1) >= 0;
    }

    private static final Date parseISODate(String stringValue) {
        try {
            return TagUtils.getDateFormat().parse(stringValue);
        }
        catch (ParseException pe) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("CANNOT_PARSE_VALUE_INTO_DATE_WITH_YYYY_MM_DD_PATTERN " + stringValue), (Throwable)pe);
            }
            return null;
        }
    }

    private static Locale getLocaleInternal(String locale) {
        String localeStr = locale.replace('-', '_');
        String[] tokens = localeStr.split("[_]", 3);
        Locale locl = null;
        if (tokens.length == 1) {
            locl = new Locale(tokens[0]);
        } else if (tokens.length == 2) {
            locl = new Locale(tokens[0], tokens[1]);
        } else if (tokens.length == 3) {
            locl = new Locale(tokens[0], tokens[1], tokens[2]);
        } else if (LOG.isWarnEnabled()) {
            LOG.warn((Object)"tokens length should not be greater than 3.");
        }
        return locl;
    }

    private static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }
}

