/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.converter;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

public class BooleanConverter
implements Converter,
StateHolder {
    private String trueValue = "true";
    private String falseValue = "false";
    private boolean isTransient;
    public static final String CONVERTER_ID = "org.apache.myfaces.custom.convertboolean.BooleanConverter";

    public String getFalseValue() {
        return this.falseValue;
    }

    public void setFalseValue(String falseValue) {
        this.falseValue = falseValue;
    }

    public String getTrueValue() {
        return this.trueValue;
    }

    public void setTrueValue(String trueValue) {
        this.trueValue = trueValue;
    }

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) throws ConverterException {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value != null && (value = value.trim()).length() > 0) {
            try {
                return value.equals(this.trueValue);
            }
            catch (Exception e) {
                throw new ConverterException((Throwable)e);
            }
        }
        return null;
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) throws ConverterException {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        try {
            return (Boolean)value != false ? this.trueValue : this.falseValue;
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean newTransientValue) {
        this.isTransient = newTransientValue;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.trueValue = (String)values[0];
        this.falseValue = (String)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.trueValue, this.falseValue};
        return values;
    }
}

