/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHelper;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import org.apache.myfaces.commons.util.MessageUtils;
import org.apache.myfaces.commons.validator._AttachedListStateWrapper;
import org.apache.myfaces.commons.validator._AttachedStateWrapper;
import org.apache.myfaces.commons.validator._DeltaStateHelper;

public abstract class ValidatorBase
implements PartialStateHolder,
Validator {
    private boolean _transient = false;
    private transient FacesContext _facesContext;
    private StateHelper _stateHelper = null;
    private boolean _initialStateMarked = false;

    public String getSummaryMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.summaryMessage));
    }

    public void setSummaryMessage(String message) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.summaryMessage), (Object)message);
    }

    public String getMessage() {
        return this.getDetailMessage();
    }

    public void setMessage(String message) {
        this.setDetailMessage(message);
    }

    public String getDetailMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.detailMessage));
    }

    public void setDetailMessage(String message) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.detailMessage), (Object)message);
    }

    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        StateHelper stateHelper = this.getStateHelper(false);
        if (stateHelper != null) {
            return stateHelper.saveState(context);
        }
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
        this.getStateHelper().restoreState(context, state);
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    protected FacesMessage getFacesMessage(String defaultMessage, Object[] args) {
        FacesMessage msg;
        if (this.getSummaryMessage() == null && this.getDetailMessage() == null) {
            msg = MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)defaultMessage, (Object[])args);
        } else {
            Locale locale = MessageUtils.getCurrentLocale();
            String summaryText = MessageUtils.substituteParams((Locale)locale, (String)this.getSummaryMessage(), (Object[])args);
            String detailText = MessageUtils.substituteParams((Locale)locale, (String)this.getDetailMessage(), (Object[])args);
            msg = new FacesMessage(FacesMessage.SEVERITY_ERROR, summaryText, detailText);
        }
        return msg;
    }

    public ValueExpression getValueExpression(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        StateHelper helper = this.getStateHelper(false);
        if (helper == null) {
            return null;
        }
        Map bindings = (Map)helper.get((Serializable)((Object)PropertyKeys.bindings));
        if (bindings == null) {
            return null;
        }
        return (ValueExpression)bindings.get(name);
    }

    public void setValueExpression(String name, ValueExpression expression) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (expression == null) {
            this.getStateHelper().remove((Serializable)((Object)PropertyKeys.bindings), (Object)name);
        } else {
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.bindings), name, (Object)expression);
        }
    }

    public static Object saveAttachedState(FacesContext context, Object attachedObject) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (attachedObject == null) {
            return null;
        }
        if (attachedObject instanceof StateHolder) {
            StateHolder holder = (StateHolder)attachedObject;
            if (holder.isTransient()) {
                return null;
            }
            return new _AttachedStateWrapper(attachedObject.getClass(), holder.saveState(context));
        }
        if (attachedObject instanceof List) {
            ArrayList<Object> lst = new ArrayList<Object>(((List)attachedObject).size());
            for (Object item : (List)attachedObject) {
                if (item == null) continue;
                lst.add(ValidatorBase.saveAttachedState(context, item));
            }
            return new _AttachedListStateWrapper(lst);
        }
        if (attachedObject instanceof Serializable) {
            return attachedObject;
        }
        return new _AttachedStateWrapper(attachedObject.getClass(), null);
    }

    public static Object restoreAttachedState(FacesContext context, Object stateObj) throws IllegalStateException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (stateObj == null) {
            return null;
        }
        if (stateObj instanceof _AttachedListStateWrapper) {
            List lst = ((_AttachedListStateWrapper)stateObj).getWrappedStateList();
            ArrayList<Object> restoredList = new ArrayList<Object>(lst.size());
            for (Object item : lst) {
                restoredList.add(ValidatorBase.restoreAttachedState(context, item));
            }
            return restoredList;
        }
        if (stateObj instanceof _AttachedStateWrapper) {
            Object restoredObject;
            Class clazz = ((_AttachedStateWrapper)stateObj).getClazz();
            try {
                restoredObject = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Could not restore StateHolder of type " + clazz.getName() + " (missing no-args constructor?)", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (restoredObject instanceof StateHolder) {
                _AttachedStateWrapper wrapper = (_AttachedStateWrapper)stateObj;
                Object wrappedState = wrapper.getWrappedStateObject();
                StateHolder holder = (StateHolder)restoredObject;
                holder.restoreState(context, wrappedState);
            }
            return restoredObject;
        }
        return stateObj;
    }

    protected FacesContext getFacesContext() {
        if (this._facesContext == null) {
            return FacesContext.getCurrentInstance();
        }
        return this._facesContext;
    }

    boolean isCachedFacesContext() {
        return this._facesContext != null;
    }

    void setCachedFacesContext(FacesContext facesContext) {
        this._facesContext = facesContext;
    }

    protected StateHelper getStateHelper() {
        return this.getStateHelper(true);
    }

    protected StateHelper getStateHelper(boolean create) {
        if (this._stateHelper != null) {
            return this._stateHelper;
        }
        if (create) {
            this._stateHelper = new _DeltaStateHelper(this);
        }
        return this._stateHelper;
    }

    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    public void markInitialState() {
        this._initialStateMarked = true;
    }

    protected String getStringValue(FacesContext context, ValueExpression vb) {
        Object value = vb.getValue(context.getELContext());
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PropertyKeys {
        bindings,
        summaryMessage,
        detailMessage;

    }
}

