/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit;

import jakarta.el.Expression;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIColumn;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIData;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.Renderer;
import jakarta.faces.view.Location;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.myfaces.application.viewstate.StateUtils;
import org.apache.myfaces.component.visit.MyFacesVisitHints;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.lifecycle.ViewNotFoundException;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.view.facelets.LocationAware;
import org.apache.myfaces.view.facelets.component.UIRepeat;
import org.apache.myfaces.view.facelets.el.ContextAware;

public final class ErrorPageWriter {
    public static final String ERROR_PAGE_BEAN_KEY = "__myFacesErrorPageBean";
    private static final String EXCEPTION_KEY = "jakarta.servlet.error.exception";
    public static final String VIEW_KEY = "org.apache.myfaces.error.UIViewRoot";
    private static final Logger log = Logger.getLogger(ErrorPageWriter.class.getName());
    private static final String TS = "&lt;";
    private static final String ERROR_TEMPLATE = "META-INF/rsc/myfaces-dev-error.xml";
    private static final String ERROR_TEMPLATE_RESOURCE = "org.apache.myfaces.ERROR_TEMPLATE_RESOURCE";
    private static String[] errorParts;
    private static final String DEBUG_TEMPLATE = "META-INF/rsc/myfaces-dev-debug.xml";
    private static final String DEBUG_TEMPLATE_RESOURCE = "org.apache.myfaces.DEBUG_TEMPLATE_RESOURCE";
    private static String[] debugParts;
    private static final Pattern REGEX_PATTERN;
    private static final String[] IGNORE;
    private static final String[] ALWAYS_WRITE;
    public static final String DEBUG_INFO_KEY = "org.apache.myfaces.debug.DEBUG_INFO";
    private static final String VISITED_FACET_COUNT_KEY = "org.apache.myfaces.debug.VISITED_FACET_COUNT";
    public static final String ERROR_HANDLING_PARAMETER = "org.apache.myfaces.ERROR_HANDLING";

    public static void debugHtml(Writer writer, FacesContext faces, Throwable e) throws IOException {
        ErrorPageWriter.debugHtml(writer, faces, faces.getViewRoot(), null, e);
    }

    /*
     * WARNING - void declaration
     */
    private static void debugHtml(Writer writer, FacesContext faces, UIViewRoot view, Collection<UIComponent> components, Throwable ... exs) throws IOException {
        ErrorPageWriter.init(faces);
        Date now = new Date();
        for (int i = 0; i < errorParts.length; ++i) {
            int n;
            if ("view".equals(errorParts[i])) {
                if (faces.getViewRoot() == null) continue;
                String viewId = faces.getViewRoot().getViewId();
                writer.write("viewId=" + viewId);
                writer.write("<br/>");
                try {
                    String string = faces.getExternalContext().getRealPath(viewId);
                    writer.write("location=" + string);
                    writer.write("<br/>");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                writer.write("phaseId=" + faces.getCurrentPhaseId());
                writer.write("<br/>");
                writer.write("<br/>");
                continue;
            }
            if ("message".equals(errorParts[i])) {
                boolean printed = false;
                Throwable[] throwableArray = exs;
                int n2 = throwableArray.length;
                for (n = 0; n < n2; ++n) {
                    Throwable e = throwableArray[n];
                    String msg = e.getMessage();
                    if (printed) {
                        writer.write("<br/>");
                    }
                    if (msg != null) {
                        writer.write(msg.replaceAll("<", TS));
                    } else {
                        writer.write(e.getClass().getName());
                    }
                    printed = true;
                }
                continue;
            }
            if ("trace".equals(errorParts[i])) {
                boolean printed = false;
                Throwable[] throwableArray = exs;
                int n3 = throwableArray.length;
                for (n = 0; n < n3; ++n) {
                    Throwable e = throwableArray[n];
                    if (printed) {
                        writer.write("\n");
                    }
                    ErrorPageWriter.writeException(writer, e);
                    printed = true;
                }
                continue;
            }
            if ("now".equals(errorParts[i])) {
                writer.write(DateFormat.getDateTimeInstance().format(now));
                continue;
            }
            if ("tree".equals(errorParts[i])) {
                if (view == null) continue;
                List<String> errorIds = ErrorPageWriter.getErrorId(components, exs);
                ErrorPageWriter.writeComponent(faces, writer, (UIComponent)view, errorIds, true);
                continue;
            }
            if ("vars".equals(errorParts[i])) {
                ErrorPageWriter.writeVariables(writer, faces, view);
                continue;
            }
            if ("cause".equals(errorParts[i])) {
                boolean printed = false;
                Object var8_18 = null;
                if (components != null) {
                    Iterator<UIComponent> iterator = components.iterator();
                }
                Throwable[] throwableArray = exs;
                n = throwableArray.length;
                for (int j = 0; j < n; ++j) {
                    UIComponent uiComponent;
                    void var8_20;
                    Throwable e = throwableArray[j];
                    if (printed) {
                        writer.write("<br/>");
                    }
                    ErrorPageWriter.writeCause(writer, e);
                    if (var8_20 != null && (uiComponent = (UIComponent)var8_20.next()) != null) {
                        ErrorPageWriter.writeComponent(faces, writer, uiComponent, null, false);
                    }
                    printed = true;
                }
                continue;
            }
            writer.write(errorParts[i]);
        }
    }

    public static void debugHtml(Writer writer, FacesContext faces) throws IOException {
        ErrorPageWriter.init(faces);
        Date now = new Date();
        for (int i = 0; i < debugParts.length; ++i) {
            if ("message".equals(debugParts[i])) {
                writer.write(faces.getViewRoot().getViewId());
                continue;
            }
            if ("now".equals(debugParts[i])) {
                writer.write(DateFormat.getDateTimeInstance().format(now));
                continue;
            }
            if ("tree".equals(debugParts[i])) {
                ErrorPageWriter.writeComponent(faces, writer, (UIComponent)faces.getViewRoot(), null, true);
                continue;
            }
            if ("extendedtree".equals(debugParts[i])) {
                ErrorPageWriter.writeExtendedComponentTree(writer, faces);
                continue;
            }
            if ("vars".equals(debugParts[i])) {
                ErrorPageWriter.writeVariables(writer, faces, faces.getViewRoot());
                continue;
            }
            writer.write(debugParts[i]);
        }
    }

    public static void handle(FacesContext facesContext, Collection<UIComponent> components, Throwable ... exs) throws FacesException {
        for (Throwable ex : exs) {
            ErrorPageWriter.prepareExceptionStack(ex);
        }
        if (!facesContext.getExternalContext().isResponseCommitted()) {
            facesContext.getExternalContext().responseReset();
        }
        int responseStatus = -1;
        for (Throwable ex : exs) {
            if (ex instanceof ViewNotFoundException) {
                responseStatus = 404;
                break;
            }
            responseStatus = 500;
        }
        if (responseStatus != -1) {
            facesContext.getExternalContext().setResponseStatus(responseStatus);
        }
        facesContext.getExternalContext().setResponseContentType("text/html");
        facesContext.getExternalContext().setResponseCharacterEncoding("UTF-8");
        try {
            Writer writer = facesContext.getExternalContext().getResponseOutputWriter();
            ErrorPageWriter.debugHtml(writer, facesContext, facesContext.getViewRoot(), components, exs);
        }
        catch (IOException ioe) {
            throw new FacesException("Could not write the error page", (Throwable)ioe);
        }
        facesContext.responseComplete();
    }

    private static String getErrorTemplate(FacesContext context) {
        String errorTemplate = context.getExternalContext().getInitParameter(ERROR_TEMPLATE_RESOURCE);
        return errorTemplate == null ? ERROR_TEMPLATE : errorTemplate;
    }

    private static String getDebugTemplate(FacesContext context) {
        String debugTemplate = context.getExternalContext().getInitParameter(DEBUG_TEMPLATE_RESOURCE);
        return debugTemplate == null ? DEBUG_TEMPLATE : debugTemplate;
    }

    private static void init(FacesContext context) throws IOException {
        if (errorParts == null) {
            errorParts = ErrorPageWriter.splitTemplate(ErrorPageWriter.getErrorTemplate(context));
        }
        if (debugParts == null) {
            debugParts = ErrorPageWriter.splitTemplate(ErrorPageWriter.getDebugTemplate(context));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] splitTemplate(String rsc) throws IOException {
        InputStream is = ClassUtils.getContextClassLoader().getResourceAsStream(rsc);
        if (is == null && (is = FacesContext.getCurrentInstance().getExternalContext().getResourceAsStream(rsc)) == null) {
            is = ErrorPageWriter.class.getClassLoader().getResourceAsStream(rsc);
        }
        if (is == null) {
            throw new IllegalArgumentException("Could not find resource " + rsc);
        }
        try {
            int read;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buff = new byte[512];
            while ((read = is.read(buff)) != -1) {
                baos.write(buff, 0, read);
            }
            String str = baos.toString();
            String[] stringArray = str.split("@@");
            return stringArray;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static List<String> getErrorId(Collection<UIComponent> components, Throwable ... exs) {
        ArrayList<String> list = null;
        for (Throwable e : exs) {
            String message = e.getMessage();
            if (message == null) continue;
            Matcher matcher = REGEX_PATTERN.matcher(message);
            while (matcher.find()) {
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(matcher.group(1));
            }
        }
        if (list != null && list.size() > 0) {
            return list;
        }
        if (components != null) {
            list = new ArrayList<String>();
            for (UIComponent uiComponent : components) {
                if (uiComponent == null) continue;
                list.add(uiComponent.getId());
            }
            return list;
        }
        return null;
    }

    private static void writeException(Writer writer, Throwable e) throws IOException {
        StringWriter str = new StringWriter(256);
        try (PrintWriter pstr = new PrintWriter(str);){
            e.printStackTrace(pstr);
        }
        writer.write(str.toString().replaceAll("<", TS));
    }

    private static void writeCause(Writer writer, Throwable ex) throws IOException {
        LocationAware laex;
        ContextAware caex;
        Object msg = ex.getMessage();
        Object locationString = null;
        if (ex instanceof ContextAware) {
            caex = (ContextAware)((Object)ex);
            locationString = caex.getLocation().toString() + "    " + caex.getQName() + "=\"" + caex.getExpressionString() + "\"";
        } else if (ex instanceof LocationAware && (laex = (LocationAware)((Object)ex)).getLocation() != null) {
            locationString = laex.getLocation().toString();
        }
        while (ex.getCause() != null) {
            if ((ex = ex.getCause()) instanceof ContextAware) {
                caex = (ContextAware)((Object)ex);
                locationString = caex.getLocation().toString() + "    " + caex.getQName() + "=\"" + caex.getExpressionString() + "\"";
            } else if (ex instanceof LocationAware && (laex = (LocationAware)((Object)ex)).getLocation() != null) {
                locationString = laex.getLocation().toString();
            }
            if (ex.getMessage() == null) continue;
            msg = ex.getMessage();
        }
        if (msg != null) {
            msg = ex.getClass().getName() + " - " + (String)msg;
            writer.write(((String)msg).replaceAll("<", TS));
        } else {
            writer.write(ex.getClass().getName());
        }
        StackTraceElement stackTraceElement = ex.getStackTrace()[0];
        writer.write("<br/> at " + stackTraceElement.toString());
        if (locationString != null) {
            writer.write("<br/> <br/>");
            writer.write("Facelet: <br/>");
            writer.write((String)locationString);
            writer.write("<br/>");
        }
    }

    private static void writeVariables(Writer writer, FacesContext faces, UIViewRoot view) throws IOException {
        MyfacesConfig config;
        ExternalContext ctx = faces.getExternalContext();
        ErrorPageWriter.writeVariables(writer, ctx.getRequestParameterMap(), "Request Parameters");
        ErrorPageWriter.writeVariables(writer, ctx.getRequestMap(), "Request Attributes");
        if (view != null) {
            ErrorPageWriter.writeVariables(writer, view.getViewMap(), "View Attributes");
        }
        if (ctx.getSession(false) != null) {
            ErrorPageWriter.writeVariables(writer, ctx.getSessionMap(), "Session Attributes");
        }
        if ((config = MyfacesConfig.getCurrentInstance(faces)) != null && !config.isFlashScopeDisabled() && ctx.getFlash() != null) {
            ErrorPageWriter.writeVariables(writer, (Map<String, ? extends Object>)ctx.getFlash(), "Flash Attributes");
        }
        ErrorPageWriter.writeVariables(writer, ctx.getApplicationMap(), "Application Attributes");
    }

    private static void writeVariables(Writer writer, Map<String, ? extends Object> vars, String caption) throws IOException {
        writer.write("<table><caption>");
        writer.write(caption);
        writer.write("</caption><thead><tr><th style=\"width: 10%; \">Name</th><th style=\"width: 90%; \">Value</th></tr></thead><tbody>");
        boolean written = false;
        if (!vars.isEmpty()) {
            TreeMap<String, ? extends Object> sortedMap = new TreeMap<String, Object>(vars);
            for (Map.Entry entry : sortedMap.entrySet()) {
                String key = (String)entry.getKey();
                if (key.indexOf(46) != -1) continue;
                writer.write("<tr><td>");
                writer.write(key.replaceAll("<", TS));
                writer.write("</td><td>");
                Object value = entry.getValue();
                if (value != null && value.toString() != null) {
                    writer.write(value.toString().replaceAll("<", TS));
                } else {
                    writer.write("null");
                }
                writer.write("</td></tr>");
                written = true;
            }
        }
        if (!written) {
            writer.write("<tr><td colspan=\"2\"><em>None</em></td></tr>");
        }
        writer.write("</tbody></table>");
    }

    private static void writeComponent(FacesContext faces, Writer writer, UIComponent c, List<String> highlightId, boolean writeChildren) throws IOException {
        int stateSize;
        boolean hasChildren;
        block10: {
            String id;
            writer.write("<dl><dt");
            if (ErrorPageWriter.isText(c)) {
                writer.write(" class=\"uicText\"");
            }
            if (highlightId != null && highlightId.size() > 0 && highlightId.contains(id = c.getId())) {
                writer.write(" class=\"highlightComponent\"");
            }
            writer.write(">");
            hasChildren = (c.getChildCount() > 0 || c.getFacetCount() > 0) && writeChildren;
            stateSize = 0;
            Object state = c.saveState(faces);
            if (state != null) {
                try {
                    byte[] stateBytes = StateUtils.getAsByteArray(state, faces.getExternalContext());
                    stateSize = stateBytes.length;
                }
                catch (Exception e) {
                    stateSize = -1;
                    if (!log.isLoggable(Level.FINEST)) break block10;
                    log.fine("Could not determine state size: " + e.getMessage());
                }
            }
        }
        ErrorPageWriter.writeStart(writer, c, hasChildren, true);
        writer.write(" - State size:" + stateSize + " bytes");
        writer.write("</dt>");
        if (hasChildren) {
            if (c.getFacetCount() > 0) {
                for (Map.Entry entry : c.getFacets().entrySet()) {
                    writer.write("<dd class=\"uicFacet\">");
                    writer.write("<span>");
                    writer.write((String)entry.getKey());
                    writer.write("</span>");
                    ErrorPageWriter.writeComponent(faces, writer, (UIComponent)entry.getValue(), highlightId, true);
                    writer.write("</dd>");
                }
            }
            if (c.getChildCount() > 0) {
                int childCount = c.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    UIComponent child = (UIComponent)c.getChildren().get(i);
                    writer.write("<dd>");
                    ErrorPageWriter.writeComponent(faces, writer, child, highlightId, writeChildren);
                    writer.write("</dd>");
                }
            }
            writer.write("<dt>");
            ErrorPageWriter.writeEnd(writer, c);
            writer.write("</dt>");
        }
        writer.write("</dl>");
    }

    private static void writeExtendedComponentTree(Writer writer, FacesContext facesContext) throws IOException {
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, MyFacesVisitHints.SET_SKIP_UNRENDERED);
        facesContext.getViewRoot().visitTree(visitContext, (VisitCallback)new ExtendedComponentTreeVisitCallback(writer));
        ErrorPageWriter.clearVisitedFacetCountMap(facesContext);
    }

    private static boolean isFirstUIColumn(UIComponent uidata, UIColumn uicolumn) {
        int childCount = uidata.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            UIComponent child = (UIComponent)uidata.getChildren().get(i);
            if (!(child instanceof UIColumn)) continue;
            return child == uicolumn;
        }
        return false;
    }

    private static String getFacetName(UIComponent component) {
        UIComponent parent = component.getParent();
        if (parent != null && parent.getFacetCount() > 0) {
            for (Map.Entry entry : parent.getFacets().entrySet()) {
                if (entry.getValue() != component) continue;
                return (String)entry.getKey();
            }
        }
        return null;
    }

    private static int getVisitedFacetCount(FacesContext facesContext, UIComponent component) {
        Map visitedFacetCount = (Map)facesContext.getAttributes().get(VISITED_FACET_COUNT_KEY);
        if (visitedFacetCount == null) {
            return 0;
        }
        Integer count = (Integer)visitedFacetCount.get(component);
        return count == null ? 0 : count;
    }

    private static void incrementVisitedFacetCount(FacesContext facesContext, UIComponent component) {
        Map visitedFacetCount = (Map)facesContext.getAttributes().computeIfAbsent(VISITED_FACET_COUNT_KEY, k -> new HashMap());
        visitedFacetCount.put(component, ErrorPageWriter.getVisitedFacetCount(facesContext, component) + 1);
    }

    private static void removeVisitedFacetCount(FacesContext facesContext, UIComponent component) {
        Map visitedFacetCount = (Map)facesContext.getAttributes().get(VISITED_FACET_COUNT_KEY);
        if (visitedFacetCount == null) {
            return;
        }
        visitedFacetCount.remove(component);
    }

    private static void clearVisitedFacetCountMap(FacesContext facesContext) {
        Map visitedFacetCount = (Map)facesContext.getAttributes().get(VISITED_FACET_COUNT_KEY);
        if (visitedFacetCount != null) {
            visitedFacetCount.clear();
            facesContext.getAttributes().remove(VISITED_FACET_COUNT_KEY);
        }
    }

    private static void writeEnd(Writer writer, UIComponent c) throws IOException {
        if (!ErrorPageWriter.isText(c)) {
            writer.write(TS);
            writer.write(47);
            writer.write(ErrorPageWriter.getName(c));
            writer.write(62);
        }
    }

    private static void writeAttributes(Writer writer, UIComponent c, boolean valueExpressionValues) {
        try {
            String location;
            BeanInfo info = Introspector.getBeanInfo(c.getClass());
            PropertyDescriptor[] pd = info.getPropertyDescriptors();
            Method m = null;
            Object v = null;
            ValueExpression valueExpression = null;
            String str = null;
            for (int i = 0; i < pd.length; ++i) {
                if (pd[i].getWriteMethod() == null && Arrays.binarySearch(ALWAYS_WRITE, pd[i].getName()) <= -1 || Arrays.binarySearch(IGNORE, pd[i].getName()) >= 0 || (m = pd[i].getReadMethod()) == null) continue;
                try {
                    valueExpression = c.getValueExpression(pd[i].getName());
                    if (valueExpressionValues && valueExpression != null) {
                        String expressionString = valueExpression.getExpressionString();
                        if (null == expressionString) {
                            expressionString = "";
                        }
                        ErrorPageWriter.writeAttribute(writer, pd[i].getName(), expressionString);
                        continue;
                    }
                    v = m.invoke((Object)c, null);
                    if (v == null || v instanceof Collection || v instanceof Map || v instanceof Iterator) continue;
                    str = v instanceof Expression ? ((Expression)v).getExpressionString() : v.toString();
                    ErrorPageWriter.writeAttribute(writer, pd[i].getName(), str);
                    continue;
                }
                catch (Exception expressionString) {
                    // empty catch block
                }
            }
            ValueExpression binding = c.getValueExpression("binding");
            if (binding != null) {
                ErrorPageWriter.writeAttribute(writer, "binding", binding.getExpressionString());
            }
            if ((location = ErrorPageWriter.getComponentLocation(c)) != null) {
                ErrorPageWriter.writeAttribute(writer, "location", location);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void writeAttribute(Writer writer, String name, String value) throws IOException {
        writer.write(" ");
        writer.write(name);
        writer.write("=\"");
        writer.write(value.replaceAll("<", TS));
        writer.write("\"");
    }

    private static void writeStart(Writer writer, UIComponent c, boolean children, boolean valueExpressionValues) throws IOException {
        if (ErrorPageWriter.isText(c)) {
            String str = c.toString().trim();
            writer.write(str.replaceAll("<", TS));
        } else {
            writer.write(TS);
            writer.write(ErrorPageWriter.getName(c));
            ErrorPageWriter.writeAttributes(writer, c, valueExpressionValues);
            if (children) {
                writer.write(62);
            } else {
                writer.write("/>");
            }
        }
    }

    private static String getName(UIComponent c) {
        String nm = c.getClass().getName();
        return nm.substring(nm.lastIndexOf(46) + 1);
    }

    private static boolean isText(UIComponent c) {
        return c.getClass().getName().startsWith("org.apache.myfaces.view.facelets.compiler");
    }

    private static void prepareExceptionStack(Throwable ex) {
        if (ex == null) {
            return;
        }
        if (!ErrorPageWriter.initCausePerReflection(ex, "getRootCause")) {
            ErrorPageWriter.initCausePerReflection(ex, "getCause");
        }
        ErrorPageWriter.prepareExceptionStack(ex.getCause());
    }

    private static boolean initCausePerReflection(Throwable ex, String methodName) {
        try {
            Method causeGetter = ex.getClass().getMethod(methodName, null);
            Throwable rootCause = (Throwable)causeGetter.invoke((Object)ex, (Object[])null);
            return ErrorPageWriter.initCauseIfAvailable(ex, rootCause);
        }
        catch (Exception e1) {
            return false;
        }
    }

    private static boolean initCauseIfAvailable(Throwable th, Throwable cause) {
        if (cause == null) {
            return false;
        }
        try {
            Method m = Throwable.class.getMethod("initCause", Throwable.class);
            m.invoke((Object)th, cause);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String getComponentLocation(UIComponent component) {
        Location location = (Location)component.getAttributes().get("jakarta.faces.component.VIEW_LOCATION_KEY");
        if (location != null) {
            return location.toString();
        }
        return null;
    }

    static {
        REGEX_PATTERN = Pattern.compile(".*?\\Q,Id:\\E\\s*(\\S+)\\s*\\].*?");
        IGNORE = new String[]{"parent", "rendererType"};
        ALWAYS_WRITE = new String[]{"class", "clientId"};
    }

    private static class ExtendedComponentTreeVisitCallback
    implements VisitCallback {
        private Writer writer;

        public ExtendedComponentTreeVisitCallback(Writer writer) {
            this.writer = writer;
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            block23: {
                Map requestMap = context.getFacesContext().getExternalContext().getRequestMap();
                try {
                    if (!(target instanceof UIViewRoot)) {
                        this.writer.write("<dd>");
                    }
                    UIComponent parent = target.getParent();
                    boolean hasChildren = target.getChildCount() > 0 || target.getFacetCount() > 0;
                    String facetName = ErrorPageWriter.getFacetName(target);
                    if (!(target instanceof UIColumn)) {
                        if (parent instanceof UIColumn && (parent.getChildCount() > 0 && parent.getChildren().get(0) == target || facetName != null && ErrorPageWriter.getVisitedFacetCount(context.getFacesContext(), parent) == 0)) {
                            if (parent.getParent() instanceof UIData && ErrorPageWriter.isFirstUIColumn(parent.getParent(), (UIColumn)parent)) {
                                this.writer.write("<span>Row: ");
                                int rowIndex = ((UIData)parent.getParent()).getRowIndex();
                                this.writer.write("" + rowIndex);
                                if (rowIndex == -1) {
                                    this.writer.write(" (all column facets)");
                                }
                                this.writer.write("</span>");
                            }
                            this.writer.write("<dl><dt>");
                            ErrorPageWriter.writeStart(this.writer, parent, true, false);
                            this.writer.write("</dt><dd>");
                        }
                        if (facetName != null) {
                            this.writer.write("<span>" + facetName + "</span>");
                            ErrorPageWriter.incrementVisitedFacetCount(context.getFacesContext(), parent);
                        }
                        this.writer.write("<dl><dt");
                        if (ErrorPageWriter.isText(target)) {
                            this.writer.write(" class=\"uicText\"");
                        }
                        this.writer.write(">");
                        Map debugInfos = null;
                        if (target instanceof EditableValueHolder) {
                            debugInfos = (Map)requestMap.get(ErrorPageWriter.DEBUG_INFO_KEY + target.getClientId());
                        }
                        Renderer renderer = null;
                        try {
                            Method getRenderer = UIComponent.class.getDeclaredMethod("getRenderer", FacesContext.class);
                            getRenderer.setAccessible(true);
                            renderer = (Renderer)getRenderer.invoke((Object)target, context.getFacesContext());
                        }
                        catch (Exception getRenderer) {
                            // empty catch block
                        }
                        ErrorPageWriter.writeStart(this.writer, target, hasChildren || debugInfos != null || renderer != null, false);
                        this.writer.write("</dt>");
                        if (renderer != null) {
                            this.writer.write("<div class=\"renderer\">Rendered by ");
                            this.writer.write(renderer.getClass().getCanonicalName());
                            this.writer.write("</div>");
                            if (!hasChildren && debugInfos == null) {
                                this.writer.write("<dt>");
                                ErrorPageWriter.writeEnd(this.writer, target);
                                this.writer.write("</dt>");
                            }
                        }
                        if (debugInfos != null) {
                            String fieldid = target.getClientId() + "_lifecycle";
                            this.writer.write("<div class=\"lifecycle_values_wrapper\">");
                            this.writer.write("<a href=\"#\" onclick=\"toggle('");
                            this.writer.write(fieldid);
                            this.writer.write("'); return false;\"><span id=\"");
                            this.writer.write(fieldid);
                            this.writer.write("Off\">+</span><span id=\"");
                            this.writer.write(fieldid);
                            this.writer.write("On\" style=\"display: none;\">-</span> Value Lifecycle</a>");
                            this.writer.write("<div id=\"");
                            this.writer.write(fieldid);
                            this.writer.write("\" class=\"lifecycle_values\">");
                            for (Map.Entry entry : debugInfos.entrySet()) {
                                this.writer.write("<span>");
                                this.writer.write((String)entry.getKey());
                                this.writer.write("</span><ol>");
                                int i = 0;
                                for (Object[] debugInfo : (List)entry.getValue()) {
                                    String oldValue = debugInfo[1] == null ? "null" : debugInfo[1].toString();
                                    String newValue = debugInfo[2] == null ? "null" : debugInfo[2].toString();
                                    this.writer.write("<li><b>");
                                    this.writer.write((String)entry.getKey());
                                    this.writer.write("</b> set from <b>");
                                    this.writer.write(oldValue);
                                    this.writer.write("</b> to <b>");
                                    this.writer.write(newValue);
                                    this.writer.write("</b> in Phase ");
                                    this.writer.write(debugInfo[0].toString());
                                    if (debugInfo[3] != null) {
                                        String stackTraceId = fieldid + "_" + (String)entry.getKey() + "_" + i;
                                        this.writer.write("<div class=\"stacktrace_wrapper\">");
                                        this.writer.write("<a href=\"#\" onclick=\"toggle('");
                                        this.writer.write(stackTraceId);
                                        this.writer.write("'); return false;\"><span id=\"");
                                        this.writer.write(stackTraceId);
                                        this.writer.write("Off\">+</span><span id=\"");
                                        this.writer.write(stackTraceId);
                                        this.writer.write("On\" style=\"display: none;\">-</span> Call Stack</a>");
                                        this.writer.write("<div id=\"");
                                        this.writer.write(stackTraceId);
                                        this.writer.write("\" class=\"stacktrace_values\">");
                                        this.writer.write("<ul>");
                                        for (StackTraceElement stackTraceElement : (List)debugInfo[3]) {
                                            this.writer.write("<li>");
                                            this.writer.write(stackTraceElement.toString());
                                            this.writer.write("</li>");
                                        }
                                        this.writer.write("</ul></div></div>");
                                    }
                                    this.writer.write("</li>");
                                    ++i;
                                }
                                this.writer.write("</ol>");
                            }
                            this.writer.write("</div></div>");
                            requestMap.remove(ErrorPageWriter.DEBUG_INFO_KEY + target.getClientId());
                            if (!hasChildren) {
                                this.writer.write("<dt>");
                                ErrorPageWriter.writeEnd(this.writer, target);
                                this.writer.write("</dt>");
                            }
                        }
                    }
                    if (hasChildren) break block23;
                    this.writer.write("</dl>");
                    while (parent != null && (parent.getChildCount() > 0 && parent.getChildren().get(parent.getChildCount() - 1) == target || parent.getFacetCount() != 0 && ErrorPageWriter.getVisitedFacetCount(context.getFacesContext(), parent) == parent.getFacetCount())) {
                        UIRepeat uirepeat;
                        UIData uidata;
                        ErrorPageWriter.removeVisitedFacetCount(context.getFacesContext(), parent);
                        if (!(parent instanceof UIData ? (uidata = (UIData)parent).getRowIndex() != uidata.getRowCount() - 1 : parent instanceof UIRepeat && (uirepeat = (UIRepeat)parent).getIndex() + uirepeat.getStep() < uirepeat.getRowCount())) {
                            this.writer.write("</dd><dt>");
                            ErrorPageWriter.writeEnd(this.writer, parent);
                            this.writer.write("</dt></dl>");
                            if (!(parent instanceof UIViewRoot)) {
                                this.writer.write("</dd>");
                            }
                            target = parent;
                            parent = target.getParent();
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    throw new FacesException((Throwable)ioe);
                }
            }
            return VisitResult.ACCEPT;
        }
    }

    public static class ErrorPageBean
    implements Serializable {
        private static final long serialVersionUID = -79513324193326616L;

        public String getErrorPageHtml() throws IOException {
            String head;
            String body;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Map requestMap = facesContext.getExternalContext().getRequestMap();
            Throwable t = (Throwable)requestMap.get(ErrorPageWriter.EXCEPTION_KEY);
            if (t == null) {
                throw new IllegalStateException("No Exception to handle");
            }
            UIViewRoot view = (UIViewRoot)requestMap.get(ErrorPageWriter.VIEW_KEY);
            StringWriter writer = new StringWriter();
            ErrorPageWriter.debugHtml(writer, facesContext, view, null, t);
            String html = writer.toString();
            try {
                body = html.substring(html.indexOf("<body>") + "<body>".length(), html.indexOf("</body>"));
            }
            catch (Exception e) {
                return html;
            }
            try {
                head = html.substring(html.indexOf("<head>") + "<head>".length(), html.indexOf("</head>"));
            }
            catch (Exception e) {
                return body;
            }
            StringBuilder builder = new StringBuilder(body);
            int startIndex = 0;
            try {
                while (true) {
                    int endIndex = head.indexOf("</style>", startIndex) + "</style>".length();
                    builder.append(head.substring(head.indexOf("<style", startIndex), endIndex));
                    startIndex = endIndex;
                }
            }
            catch (Exception e) {
                startIndex = 0;
                try {
                    while (true) {
                        int endIndex = head.indexOf("</script>", startIndex) + "</script>".length();
                        builder.append(head.substring(head.indexOf("<script", startIndex), endIndex));
                        startIndex = endIndex;
                    }
                }
                catch (Exception e2) {
                    return builder.toString();
                }
            }
        }
    }
}

