/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.toggle;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.toggle.AbstractTogglePanel;
import org.apache.myfaces.custom.toggle.ToggleGroup;
import org.apache.myfaces.custom.toggle.ToggleLink;
import org.apache.myfaces.custom.toggle.TogglePanel;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlGroupRendererBase;

public class TogglePanelRenderer
extends HtmlGroupRendererBase {
    private static Log log = LogFactory.getLog(TogglePanelRenderer.class);

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(context, component, TogglePanel.class);
        this.addToggleLinkJavascript(context);
        TogglePanel togglePanel = (TogglePanel)component;
        boolean toggleMode = togglePanel.isToggled();
        this.toggleVisibility(togglePanel.getChildren(), toggleMode);
        ResponseWriter writer = context.getResponseWriter();
        String hiddenFieldId = this.getHiddenFieldId(context, togglePanel);
        writer.startElement("input", component);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)hiddenFieldId, null);
        writer.writeAttribute("name", (Object)hiddenFieldId, null);
        writer.writeAttribute("value", (Object)(toggleMode ? "1" : ""), null);
        writer.endElement("input");
        super.encodeEnd(context, (UIComponent)togglePanel);
    }

    private void toggleVisibility(List children, boolean toggleMode) {
        for (UIComponent component : children) {
            TogglePanelRenderer.setComponentVisibility(component, toggleMode);
        }
    }

    public static boolean hasStyleAttribute(UIComponent component) {
        Method[] methods = component.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals("getStyle")) continue;
            return true;
        }
        return false;
    }

    public static void setComponentVisibility(UIComponent component, boolean toggleMode) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!TogglePanelRenderer.hasStyleAttribute(component)) {
            log.info((Object)("style attribute expected, not found for component " + component.getClientId(context)));
            return;
        }
        try {
            boolean display;
            Class<?> c = component.getClass();
            Method getStyle = c.getMethod("getStyle", new Class[0]);
            Method setStyle = c.getMethod("setStyle", String.class);
            String style = (String)getStyle.invoke((Object)component, new Object[0]);
            boolean bl = display = toggleMode != TogglePanelRenderer.isHiddenWhenToggled(component);
            if (display) {
                if (style == null || style.length() == 0) {
                    return;
                }
                int index = style.indexOf(";display:none;");
                if (index == -1) {
                    return;
                }
                style = index == 0 ? null : style.substring(0, index);
            } else if (style == null) {
                style = ";display:none;";
            } else if (style.indexOf("display:none;") == -1) {
                style = style.concat(";display:none;");
            }
            setStyle.invoke((Object)component, style);
        }
        catch (Throwable e) {
            log.error((Object)("unable to set style attribute on component " + component.getClientId(context)));
        }
    }

    public static boolean isHiddenWhenToggled(UIComponent component) {
        return component instanceof ToggleLink || component instanceof ToggleGroup;
    }

    private String getHiddenFieldId(FacesContext context, TogglePanel togglePanel) {
        return togglePanel.getClientId(context) + "_hidden";
    }

    public static String getToggleJavascriptFunctionName(FacesContext context, TogglePanel togglePanel) {
        return "MyFacesToggleLinkUtils.toggle";
    }

    public void addToggleLinkJavascript(FacesContext context) throws IOException {
        AddResource addResource = AddResourceFactory.getInstance(context);
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, AbstractTogglePanel.class, "MyFacesToggleLink.js");
    }
}

