/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.converter;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.MetaRuleset;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import com.sun.facelets.tag.jsf.ConvertHandler;
import com.sun.facelets.tag.jsf.ConverterConfig;

public class ConvertEnumTagHandler extends ConvertHandler
{
    private final TagAttribute targetClass;
    
    public ConvertEnumTagHandler(ConverterConfig config)
    {
        super(config);
        this.targetClass = this.getAttribute("targetClass");
    }

    public void setAttributes(FaceletContext ctx, Object obj)
    {
        super.setAttributes(ctx, obj);
        EnumConverter c = (EnumConverter) obj;
        if (this.targetClass != null)
        {
            if (this.targetClass.isLiteral())
            {
                try
                {
                    c.setTargetClass(org.apache.myfaces.commons.util.ClassUtils.classForName(this.targetClass.getValue()));
                }
                catch (ClassNotFoundException e)
                {
                    throw new TagAttributeException(this.targetClass,"Cannot find class assigned: "+this.targetClass.getValue(),e);
                }
            }
            else
            {
                c.setTargetClass((Class) this.targetClass.getObject(ctx, Class.class));
            }
        }
    }

    @Override
    protected MetaRuleset createMetaRuleset(Class type)
    {
        return super.createMetaRuleset(type).ignore("targetClass");
    }
}
