/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.resourcehandler.config;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;

import javax.faces.FacesException;
import javax.faces.context.ExternalContext;

import org.apache.myfaces.commons.util.ClassUtils;

/**
 * Default implementation used to load myfaces-resources-config.xml files
 * 
 * @author Leonardo Uribe
 *
 */
public class DefaultMyFacesResourceHandlerUrlProvider extends MyFacesResourceHandlerUrlProvider
{

    public Collection<URL> getMetaInfConfigurationResources(ExternalContext context) throws IOException
    {
        ClassLoader contextClassLoader = ClassUtils.getContextClassLoader();
        Enumeration<URL> metaInfConfigUrls = null;
        List<URL> configUrls = new ArrayList<URL>(); 

        try
        {
            // NOTE that there could be multiple config files (in different jar files)
            metaInfConfigUrls = contextClassLoader.getResources(META_INF_CONFIG_FILE);
        }
        catch (IOException e)
        {
            throw new FacesException("Could not open " + MyFacesResourceHandlerUrlProvider.META_INF_CONFIG_FILE, e);
        }

        if (metaInfConfigUrls != null && metaInfConfigUrls.hasMoreElements())
        {
            while (metaInfConfigUrls.hasMoreElements())
            {
                URL url = metaInfConfigUrls.nextElement();
                if (url != null)
                {
                    configUrls.add(url);
                }
            }
        }

        return configUrls;
    }

    public URL getWebInfConfigurationResource(ExternalContext context) throws IOException
    {
        return context.getResource(WEB_INF_CONFIG_FILE);
    }
}
