/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * helpers with various init and html patterns
 *
 * We use jsdom global which builds up a
 * dom tree and emulates a full environment
 *
 * Note the buildup and loading is asynchronous so
 * we have to work with Promises and asyncs to get things
 * where we want to have them
 *
 * This is a pattern pretty much for every test which iterates over
 * multiple doms
 */
export declare module StandardInits {
    const HTML_DEFAULT = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <title>Title</title>\n</head>\n<body>\n<div id=\"id_1\"></div>\n<div id=\"id_2\" booga=\"blarg\"></div>\n<div id=\"id_3\"></div>\n<div id=\"id_4\"></div>\n</body>\n</html>";
    const HTML_SHADOW = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <title>Title</title>\n</head>\n<body>\n<form id=\"blarg\">\n    <input type=\"text\" id=\"blarg:input_1\" name=\"blarg:input_1\" value=\"input_1_val\"></input>\n    <input type=\"hidden\" id=\"jakarta.faces.ViewState\" name=\"jakarta.faces.ViewState\" value=\"blubbblubblubb\"></input>\n    <input type=\"button\" id=\"blarg:input_2\" name=\"blarg:input_2\" value=\"input_1_val\"></input>\n    <div id=\"shadowDomArea\">\n            <input type=\"button\" id=\"blarg:input_3\" name=\"blarg:input_3\" value=\"input_3_val\"></input>\n    </div>\n</form>\n</body>\n</html>";
    const HTML_TOBAGO_SHEET_WITH_STYLE = "<!DOCTYPE html>\n<html lang='de'>\n<head>\n  <meta charset='UTF-8'>\n  <meta name='viewport' content='width=device-width, initial-scale=1.0'>\n  <title>Test\n  </title>\n  <link rel='stylesheet' href='./fixtures/css/tobago.css' type='text/css'>\n  <link rel='stylesheet' href='./fixtures/css/css/bootstrap-icons.css' type='text/css'>\n  <script src='./fixtures/jakarta.faces.resource/faces.js.jsf' type='text/javascript'></script>\n  <script src='./fixtures/js/tobago.js' type='module'></script>\n</head>\n<body>\n<tobago-page locale='de' class='container-fluid' id='page' focus-on-error='true' wait-overlay-delay-full='1000'\n             wait-overlay-delay-ajax='1000'>\n  <form action='/content/080-sheet/30-event/Sheet_Event.xhtml' id='page::form' method='post'\n        accept-charset='UTF-8' data-tobago-context-path=''>\n    <input type='hidden' name='javax.faces.source' id='javax.faces.source' disabled='disabled'>\n    <tobago-focus id='page::lastFocusId'>\n      <input type='hidden' name='page::lastFocusId' id='page::lastFocusId::field'>\n    </tobago-focus>\n    <input type='hidden' name='org.apache.myfaces.tobago.webapp.Secret' id='org.apache.myfaces.tobago.webapp.Secret'\n           value='secretValue'>\n    <div class='tobago-page-menuStore'>\n    </div>\n    <span id='page::jsf-state-container'><input type='hidden' name='javax.faces.ViewState'\n                                                id='j_id__v_0:javax.faces.ViewState:1'\n                                                value='viewStateValue' autocomplete='off'><input\n            type='hidden' name='javax.faces.RenderKitId' value='tobago'><input type='hidden'\n                                                                               id='j_id__v_0:javax.faces.ClientWindow:1'\n                                                                               name='javax.faces.ClientWindow'\n                                                                               value='clientWindowValue'></span>\n    <button type='button' id='page:ajaxButton' name='page:ajaxButton'\n            class='tobago-button btn btn-secondary tobago-auto-spacing'>\n      <tobago-behavior event='click' client-id='page:ajaxButton' execute='page:ajaxButton'\n                       render='page:s1'></tobago-behavior>\n      <span>Ajax</span></button>\n    <tobago-sheet id='page:s1' data-tobago-selection-mode='multi' data-tobago-first='0' rows='0' row-count='2'>\n      <style nonce='nonceValue' id='page:s1:j_id_4'>#page\\:s1 {\n        max-height: 500px;\n      }\n      </style>\n      <input id='page:s1::scrollPosition' name='page:s1::scrollPosition' type='hidden' value='[0,0]'>\n      <input id='page:s1::selected' name='page:s1::selected' type='hidden' value='[]'>\n      <div class='tobago-body'>\n        <table cellspacing='0' cellpadding='0' summary='' class='table'>\n          <thead>\n          <tr>\n            <th>\n              <span><tobago-out id='page:s1:_col0'><span class='form-control-plaintext'>Name</span></tobago-out></span>\n            </th>\n          </tr>\n          </thead>\n          <tbody>\n          <tr row-index='0'>\n            <td>\n              <tobago-out id='page:s1:0:t_name'><span class='form-control-plaintext'>Earth</span></tobago-out>\n            </td>\n            <td>\n              <div>\n              </div>\n            </td>\n          </tr>\n          <tr row-index='1'>\n            <td>\n              <tobago-out id='page:s1:1:t_name'><span class='form-control-plaintext'>Moon</span></tobago-out>\n            </td>\n            <td>\n              <div>\n              </div>\n            </td>\n          </tr>\n          </tbody>\n        </table>\n      </div>\n    </tobago-sheet>\n  </form>\n  <noscript>\n    <div class='tobago-page-noscript'>Diese Seite ben\u00F6tigt JavaScript, allerdings ist JavaScript in Ihrem Browser\n      derzeit deaktiviert. Um JavaScript zu aktivieren, lesen Sie ggf. die Anleitung Ihres Browsers.\n    </div>\n  </noscript>\n</tobago-page>\n</body>\n</html>";
    /**
     * a page simulating basically a simple faces form
     */
    const HTML_PREFIX_EMBEDDED_BODY = "<form id=\"form1\">\n  <tobago-in id=\"page:input\" class=\"tobago-auto-spacing\">\n     <input type=\"text\" name=\"page:input\" id=\"page:input::field\" class=\"form-control\" value=\"input_value\">\n     <tobago-behavior event=\"change\" client-id=\"page:input\" field-id=\"page:input::field\" execute=\"page:input\" render=\"page:output\"></tobago-behavior>\n  </tobago-in>\n  \n  <tobago-out id=\"page:output\" class=\"tobago-auto-spacing\">\n    <input type=\"text\" name=\"page:output\" id=\"page:output::field\" class=\"form-control\">\n  </tobago-out>\n</form>";
    const STD_XML = "<?xml version=\"1.0\" encoding=\"utf-8\"?><partial-response><changes><update id=\"value_1\"><![CDATA[<span id=\"out1\">2</span>]]></update><update id=\"jakarta.faces.ViewState\"><![CDATA[j_id1:j_id3]]></update></changes></partial-response>";
    const ERROR_CHAIN_PAGE = "\n    <!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <title>Title</title>\n</head>\n<body>\n<h2>Error Chain Testcase</h2>\n<script type=\"text/javascript\">\n/**\n* code identical to mojarra test, both stem from me\n* so mojarras side EPL here ASL2!\n* \n* @param event\n*/\nfunction triggerRequestChain(event) {\n    for(let cnt = 0; cnt < 5; cnt++) {\n        faces.ajax.request(event.target, \"click\", {\n            render:\"form1\",\n            onerror: function() {\n                document.getElementById(\"errorCalled\").innerHTML = \"1\";\n            }\n        })\n    }\n}\n</script>\n<div id=\"errorCalled\"></div>\n<form id=\"form1\">\n    <div id=\"form1:out1\">0</div>\n    <input type=\"button\" id=\"form1:button1\" onclick=\"triggerRequestChain(event)\">\n</form>\n</body>\n</html>\n    ";
    /**
     * This is a standardized small page mockup
     * testing the various aspects of the protocol
     * under pure html conditions
     *
     * We get the jsf out of the way and basically simulate what the browser sees
     */
    const PROTOCOL_PAGE = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <title>Title</title>\n</head>\n<body>\n<h2>protocol testcase1</h2>\n\n<div id=\"centerDiv\">\n\n    <h1>Selenium Testprobe for insert update delete and attribute change</h1>\n\n    <h2>This test tests all aspects of the protocol, under xhr and iframe conditions</h2>\n\n    <div id=\"testResults\">\n        \n        <h3>Test Results</h3>\n\n        <div id=\"evalarea1\">eval area 1 triggered by eval</div>\n        \n        <div id=\"evalarea2\">eval area 2 triggered by update</div>\n        \n        <div id=\"evalarea3\">eval area 3 triggered by insert</div>\n        \n        <div id=\"evalarea4\">eval area 4 triggered by a click on the changed attributes area</div>\n\n        <div id=\"changesArea\">update insert area</div>\n        \n        <div id=\"deleteable\">delete area will be deleted once you press the delete button</div>\n        \n        <div id=\"attributeChange\">attributes changes area</div>\n    \n        <div id=\"resource_area_1\"></div>\n        <div id=\"resource_area_2\"></div>\n        <div id=\"resource_area_3\"></div>\n        <div id=\"nonce_result\"></div>\n   \n    </div>\n\n    <h2>Call actions via normal ppr</h2>\n\n    <form id=\"form1\" action=\"boog.html\">\n    \n        <input type=\"hidden\" id=\"jakarta.faces.ViewState\" name=\"jakarta.faces.ViewState\" value=\"blubbblubblubb\"></input>\n    \n        <input type=\"button\" id=\"cmd_eval\" value=\"eval\"\n               onclick=\"emitPPR(this, ('undefined' == typeof event)? null: event, 'eval1');\"/>\n               \n        <input type=\"button\" id=\"cmd_update_insert\" value=\"update insert\"\n               onclick=\"emitPPR(this, ('undefined' == typeof event)? null: event, 'updateinsert1');\"/>\n\n        <input type=\"button\" id=\"cmd_simple_resource\" value=\"simple resource\"\n               onclick=\"emitPPR(this, ('undefined' == typeof event)? null: event, 'simpleresource');\"/>\n\n        <input type=\"button\" id=\"cmd_complex_resource\" value=\"complex resource\"\n               onclick=\"emitPPR(this, ('undefined' == typeof event)? null: event, 'complex_resource');\"/>\n               \n        <input type=\"button\" id=\"cmd_complex_resource2\" value=\"complex resource2\"\n               onclick=\"emitPPR(this, ('undefined' == typeof event)? null: event, 'complex_resource2');\"/>       \n               \n        <input type=\"button\" id=\"cmd_update_insert2\" value=\"update insert second protocol path\"\n               onclick=\"emitPPR(this, ('undefined' == typeof event)? null: event, 'updateinsert2');\"/>\n\n        <input type=\"button\" id=\"cmd_delete\" value=\"delete\"\n               onclick=\"emitPPR(this, ('undefined' == typeof event)? null: event, 'delete1');\"/>\n\n        <input type=\"button\" id=\"cmd_replace\" value=\"Replace Body\"\n               onclick=\"emitPPR(this, ('undefined' == typeof event)? null: event, 'body_replace1');\"/>\n\n        <input type=\"button\" id=\"cmd_attributeschange\" value=\"change attributes\"\n               onclick=\"emitPPR(this, ('undefined' == typeof event)? null: event, 'attributes');\"/>\n\n        <input type=\"button\" id=\"cmd_illegalresponse\" value=\"illegal response, error trigger\"\n               onclick=\"emitPPR(this, ('undefined' == typeof event)? null: event, 'illegalResponse');\"/>\n\n        <input type=\"button\" id=\"cmd_viewstate\" value=\"Viewstate only update trigger\"\n               onclick=\"emitPPR(this, ('undefined' == typeof event)? null: event, 'viewstate');\"/>\n\n        <input type=\"button\" id=\"cmd_error\" value=\"Server error with error response\"\n               onclick=\"emitPPR(this, ('undefined' == typeof event)? null: event, 'errors');\"/>\n\n        <input type=\"button\" id=\"cmd_error_component\" value=\"Error: no component given\"\n               onclick=\"(window.faces || window.jsf).ajax.request(null, event, {}); return false\"/>\n\n    </form>\n\n    <script type=\"text/javascript\">\n        document.getElementById(\"evalarea1\").innerHTML = \"booga\";\n\n        var target = \"./test.mockup\";\n\n        function emitPPR(source, event, action, useIframe, formName) {\n            document.getElementById(formName || \"form1\").action = target;\n\n            (window?.faces ?? window.jsf).ajax.request(/*String|Dom Node*/ source, /*|EVENT|*/ (window.event) ? window.event : event, /*{|OPTIONS|}*/ {op: action});\n        }\n    </script>\n</div>\n</body>";
    function basicXML(): Document;
    function standardInit(scope: any, initFunc?: (boolean: any) => Promise<() => void>): Promise<any>;
    function standardClose(scope: any): void;
    function defaultHtml(withJsf?: boolean): Promise<() => void>;
    function defaultHtml_23(withJsf?: boolean): Promise<() => void>;
    function defaultMyFaces(withJsf?: boolean): Promise<() => void>;
    function defaultMyFacesNamespaces(withJsf?: boolean): Promise<() => void>;
    function defaultMyFaces23(withJsf?: boolean): Promise<() => void>;
    function defaultFileForm(withJsf?: boolean): Promise<() => void>;
    function tobagoFileForm(withJsf?: boolean): Promise<() => void>;
    function defaultFileForm_23(withJsf?: boolean): Promise<() => void>;
    function shadowDomMyFaces(withJsf?: boolean): Promise<() => void>;
    function protocolPage(withJsf?: boolean, IS_40?: boolean): Promise<() => void>;
    function errorChainPage(withJsf?: boolean, IS_40?: boolean): Promise<() => void>;
    function prefixEmbeddedPage(withJsf?: boolean, IS_40?: boolean): Promise<() => void>;
    function defaultSeparatorChar(separatorChar: string, withJsf?: boolean, IS_40?: boolean): Promise<() => void>;
}
