"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const mocha_1 = require("mocha");
const chai_1 = require("chai");
const sinon = __importStar(require("sinon"));
const StandardInits_1 = require("../frameworkBase/_ext/shared/StandardInits");
var defaultMyFaces = StandardInits_1.StandardInits.defaultMyFaces;
var defaultSeparatorChar = StandardInits_1.StandardInits.defaultSeparatorChar;
sinon.reset();
(0, mocha_1.describe)('various tests for get separator char', () => {
    (0, mocha_1.it)("should have : as standard separator char", (done) => {
        let waitForResult = defaultMyFaces();
        waitForResult.then((close) => {
            try {
                let separator = faces.separatorchar;
                (0, chai_1.expect)(separator).to.eq(":");
            }
            finally {
                Implementation.reset();
                close();
                done();
            }
        });
    });
    (0, mocha_1.it)("should have a custom separator char", (done) => {
        let waitForResult = defaultSeparatorChar("$", false);
        waitForResult.then((close) => {
            try {
                let separator = Implementation.getSeparatorChar();
                (0, chai_1.expect)(separator).to.eq("$");
                done();
            }
            catch (ex) {
                console.error(ex);
                (0, chai_1.expect)(false).to.eq(true);
            }
            finally {
                Implementation.reset();
                close();
            }
        });
    });
    (0, mocha_1.it)("should have a url encoded separator char", (done) => {
        let waitForResult = defaultSeparatorChar("%21");
        waitForResult.then((close) => {
            try {
                let separator = Implementation.getSeparatorChar();
                (0, chai_1.expect)(separator).to.eq("!");
                done();
            }
            finally {
                Implementation.reset();
                close();
            }
        });
    });
});
//# sourceMappingURL=SeparatorCharsTest.spec.js.map